/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.util.Util;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class ResultDirective
extends Directive {
    private static final Map<String, String> typesGuess = new HashMap<String, String>();

    public String getName() {
        return "result";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object jdbcType;
        String column = this.getChildAsString(context, node, 0);
        if (column == null) {
            throw new ParseErrorException("Column name expected at line " + node.getLine() + ", column " + node.getColumn());
        }
        String alias = this.getChildAsString(context, node, 2);
        String dataRowKey = this.getChildAsString(context, node, 3);
        String label = !Util.isEmptyString((CharSequence)dataRowKey) ? dataRowKey : (!Util.isEmptyString((CharSequence)alias) ? alias : null);
        ColumnDescriptor columnDescriptor = new ColumnDescriptor();
        columnDescriptor.setName(column);
        columnDescriptor.setDataRowKey(label);
        String type = this.getChildAsString(context, node, 1);
        if (type != null) {
            columnDescriptor.setJavaClass(this.guessType(type));
        }
        if ((jdbcType = this.getChild(context, node, 4)) instanceof Number) {
            columnDescriptor.setJdbcType(((Number)jdbcType).intValue());
        }
        writer.write(column);
        if (!Util.isEmptyString((CharSequence)alias) && !alias.equals(column)) {
            writer.write(" AS ");
            writer.write(alias);
        }
        this.bindResult(context, columnDescriptor);
        return true;
    }

    protected Object getChild(InternalContextAdapter context, Node node, int i) throws MethodInvocationException {
        return i >= 0 && i < node.jjtGetNumChildren() ? node.jjtGetChild(i).value(context) : null;
    }

    protected String getChildAsString(InternalContextAdapter context, Node node, int i) throws MethodInvocationException {
        Object value = this.getChild(context, node, i);
        return value != null ? value.toString() : null;
    }

    protected String guessType(String type) {
        String guessed = typesGuess.get(type);
        return guessed != null ? guessed : type;
    }

    protected void bindResult(InternalContextAdapter context, ColumnDescriptor columnDescriptor) {
        Collection resultColumns = (Collection)context.getInternalUserContext().get("resultColumns");
        if (resultColumns != null) {
            resultColumns.add(columnDescriptor);
        }
    }

    static {
        typesGuess.put("long", Long.class.getName());
        typesGuess.put("double", Double.class.getName());
        typesGuess.put("byte", Byte.class.getName());
        typesGuess.put("boolean", Boolean.class.getName());
        typesGuess.put("float", Float.class.getName());
        typesGuess.put("short", Short.class.getName());
        typesGuess.put("int", Integer.class.getName());
        typesGuess.put("Long", Long.class.getName());
        typesGuess.put("Double", Double.class.getName());
        typesGuess.put("Byte", Byte.class.getName());
        typesGuess.put("Boolean", Boolean.class.getName());
        typesGuess.put("Float", Float.class.getName());
        typesGuess.put("Short", Short.class.getName());
        typesGuess.put("Integer", Integer.class.getName());
        typesGuess.put("String", String.class.getName());
        typesGuess.put("Date", Date.class.getName());
        typesGuess.put("Time", Time.class.getName());
        typesGuess.put("Timestamp", Timestamp.class.getName());
        typesGuess.put("BigDecimal", BigDecimal.class.getName());
        typesGuess.put("BigInteger", BigInteger.class.getName());
    }
}

