/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.dbsync.reverse.dbload.DbRelationshipDetected;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

public class DropRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship relationship;

    public DropRelationshipToDb(DbEntity entity, DbRelationship relationship) {
        super("Drop foreign key", 10, entity);
        this.relationship = relationship;
    }

    public String getFkName() {
        if (this.relationship instanceof DbRelationshipDetected) {
            return ((DbRelationshipDetected)this.relationship).getFkName();
        }
        return null;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        QuotingStrategy context = adapter.getQuotingStrategy();
        return Collections.singletonList("ALTER TABLE " + context.quotedFullyQualifiedName(this.getEntity()) + " DROP CONSTRAINT " + this.getFkName());
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createAddRelationshipToModel(this.getEntity(), this.relationship);
    }

    @Override
    public boolean isEmpty() {
        return this.getFkName() == null || this.relationship.isToMany();
    }

    @Override
    public String getTokenValue() {
        if (this.relationship.isToMany()) {
            return "Skip. No sql representation.";
        }
        return ((DbEntity)this.relationship.getSourceEntity()).getName() + "->" + this.relationship.getTargetEntityName();
    }
}

