/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;

public class LimitOffsetNode
extends Node {
    protected final int limit;
    protected final int offset;

    public LimitOffsetNode(int limit, int offset) {
        super(NodeType.LIMIT_OFFSET);
        this.limit = limit;
        this.offset = offset;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        if (this.limit == 0 && this.offset == 0) {
            return buffer;
        }
        return buffer.append(" LIMIT ").append(this.limit).append(" OFFSET ").append(this.offset);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Node copy() {
        return new LimitOffsetNode(this.limit, this.offset);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitOffsetNode that = (LimitOffsetNode)o;
        return this.limit == that.limit && this.offset == that.offset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit, this.offset);
    }
}

