/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelLoaderListener;
import org.apache.cayenne.configuration.xml.DataMapLoaderListener;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.map.DataMap;
import org.xml.sax.XMLReader;

public class LoaderContext {
    Collection<DataMapLoaderListener> dataMapListeners;
    Collection<DataChannelLoaderListener> dataChannelListeners;
    private XMLReader xmlReader;
    private HandlerFactory factory;

    public LoaderContext(XMLReader reader, HandlerFactory factory) {
        this.xmlReader = reader;
        this.factory = factory;
        this.dataMapListeners = new ArrayList<DataMapLoaderListener>();
        this.dataChannelListeners = new ArrayList<DataChannelLoaderListener>();
    }

    public HandlerFactory getFactory() {
        return this.factory;
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    public void addDataMapListener(DataMapLoaderListener listener) {
        this.dataMapListeners.add(listener);
    }

    public void dataMapLoaded(DataMap dataMap) {
        for (DataMapLoaderListener listener : this.dataMapListeners) {
            listener.onDataMapLoaded(dataMap);
        }
    }

    public void addDataChannelListener(DataChannelLoaderListener listener) {
        this.dataChannelListeners.add(listener);
    }

    public void dataChannelLoaded(DataChannelDescriptor descriptor) {
        for (DataChannelLoaderListener listener : this.dataChannelListeners) {
            listener.onDataChannelLoaded(descriptor);
        }
    }
}

