/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.time.LocalDateTime;
import org.apache.cayenne.EmbeddableObject;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.BaseIdProperty;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.EmbeddableProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.SetProperty;
import org.apache.cayenne.exp.property.StringProperty;

public class PropertyFactory {
    public static final NumericProperty<Long> COUNT = PropertyFactory.createNumeric(FunctionExpressionFactory.countExp(), Long.class);
    public static final DateProperty<LocalDateTime> NOW = PropertyFactory.createDate(FunctionExpressionFactory.currentTimestamp(), LocalDateTime.class);

    public static <T> BaseProperty<T> createBase(String name, Expression expression, Class<T> type) {
        return PropertyFactory.createBase(CayennePath.of(name), expression, type);
    }

    public static <T> BaseProperty<T> createBase(CayennePath path, Expression expression, Class<T> type) {
        return new BaseProperty<T>(path, expression, type);
    }

    public static <T> BaseProperty<T> createBase(String name, Class<T> type) {
        return PropertyFactory.createBase(CayennePath.of(name), null, type);
    }

    public static <T> BaseProperty<T> createBase(CayennePath path, Class<T> type) {
        return PropertyFactory.createBase(path, null, type);
    }

    public static <T> BaseProperty<T> createBase(Expression expression, Class<T> type) {
        return PropertyFactory.createBase(CayennePath.EMPTY_PATH, expression, type);
    }

    public static <T extends CharSequence> StringProperty<T> createString(CayennePath path, Expression expression, Class<T> type) {
        return new StringProperty<T>(path, expression, type);
    }

    public static <T extends CharSequence> StringProperty<T> createString(String name, Expression expression, Class<T> type) {
        return PropertyFactory.createString(CayennePath.of(name), expression, type);
    }

    public static <T extends CharSequence> StringProperty<T> createString(CayennePath path, Class<T> type) {
        return PropertyFactory.createString(path, null, type);
    }

    public static <T extends CharSequence> StringProperty<T> createString(String name, Class<T> type) {
        return PropertyFactory.createString(CayennePath.of(name), null, type);
    }

    public static <T extends CharSequence> StringProperty<T> createString(Expression expression, Class<T> type) {
        return PropertyFactory.createString(CayennePath.EMPTY_PATH, expression, type);
    }

    public static <T extends Number> NumericProperty<T> createNumeric(CayennePath path, Expression expression, Class<T> type) {
        return new NumericProperty<T>(path, expression, type);
    }

    public static <T extends Number> NumericProperty<T> createNumeric(String name, Expression expression, Class<T> type) {
        return PropertyFactory.createNumeric(CayennePath.of(name), expression, type);
    }

    public static <T extends Number> NumericProperty<T> createNumeric(String name, Class<T> type) {
        return PropertyFactory.createNumeric(CayennePath.of(name), null, type);
    }

    public static <T extends Number> NumericProperty<T> createNumeric(Expression expression, Class<T> type) {
        return PropertyFactory.createNumeric(CayennePath.EMPTY_PATH, expression, type);
    }

    public static <T> DateProperty<T> createDate(CayennePath path, Expression expression, Class<T> type) {
        return new DateProperty<T>(path, expression, type);
    }

    public static <T> DateProperty<T> createDate(String name, Expression expression, Class<T> type) {
        return PropertyFactory.createDate(CayennePath.of(name), expression, type);
    }

    public static <T> DateProperty<T> createDate(CayennePath path, Class<T> type) {
        return PropertyFactory.createDate(path, null, type);
    }

    public static <T> DateProperty<T> createDate(String name, Class<T> type) {
        return PropertyFactory.createDate(CayennePath.of(name), null, type);
    }

    public static <T> DateProperty<T> createDate(Expression expression, Class<T> type) {
        return PropertyFactory.createDate(CayennePath.EMPTY_PATH, expression, type);
    }

    public static <T extends Persistent> EntityProperty<T> createEntity(CayennePath path, Expression expression, Class<T> entityType) {
        return new EntityProperty<T>(path, expression, entityType);
    }

    public static <T extends Persistent> EntityProperty<T> createEntity(String name, Expression expression, Class<T> entityType) {
        return PropertyFactory.createEntity(CayennePath.of(name), expression, entityType);
    }

    public static <T extends Persistent> EntityProperty<T> createEntity(CayennePath path, Class<T> type) {
        return PropertyFactory.createEntity(path, null, type);
    }

    public static <T extends Persistent> EntityProperty<T> createEntity(String name, Class<T> type) {
        return PropertyFactory.createEntity(CayennePath.of(name), null, type);
    }

    public static <T extends Persistent> EntityProperty<T> createEntity(Expression expression, Class<T> type) {
        return PropertyFactory.createEntity(CayennePath.EMPTY_PATH, expression, type);
    }

    public static <T extends Persistent> SelfProperty<T> createSelf(Class<T> type) {
        return new SelfProperty<T>(CayennePath.EMPTY_PATH, ExpressionFactory.fullObjectExp(), type);
    }

    public static <T extends Persistent> EntityProperty<T> createSelf(Expression expression, Class<T> type) {
        return PropertyFactory.createEntity(ExpressionFactory.fullObjectExp(expression), type);
    }

    public static <T extends Persistent> ListProperty<T> createList(CayennePath path, Expression expression, Class<T> entityType) {
        return new ListProperty<T>(path, expression, entityType);
    }

    public static <T extends Persistent> ListProperty<T> createList(String name, Expression expression, Class<T> entityType) {
        return PropertyFactory.createList(CayennePath.of(name), expression, entityType);
    }

    public static <T extends Persistent> ListProperty<T> createList(CayennePath path, Class<T> entityType) {
        return PropertyFactory.createList(path, null, entityType);
    }

    public static <T extends Persistent> ListProperty<T> createList(String name, Class<T> entityType) {
        return PropertyFactory.createList(CayennePath.of(name), null, entityType);
    }

    public static <T extends Persistent> SetProperty<T> createSet(CayennePath path, Expression expression, Class<T> entityType) {
        return new SetProperty<T>(path, expression, entityType);
    }

    public static <T extends Persistent> SetProperty<T> createSet(String name, Expression expression, Class<T> entityType) {
        return PropertyFactory.createSet(CayennePath.of(name), expression, entityType);
    }

    public static <T extends Persistent> SetProperty<T> createSet(CayennePath path, Class<T> entityType) {
        return PropertyFactory.createSet(path, null, entityType);
    }

    public static <T extends Persistent> SetProperty<T> createSet(String name, Class<T> entityType) {
        return PropertyFactory.createSet(CayennePath.of(name), null, entityType);
    }

    public static <K, V extends Persistent> MapProperty<K, V> createMap(CayennePath path, Expression expression, Class<K> keyType, Class<V> entityType) {
        return new MapProperty<K, V>(path, expression, keyType, entityType);
    }

    public static <K, V extends Persistent> MapProperty<K, V> createMap(String name, Expression expression, Class<K> keyType, Class<V> entityType) {
        return PropertyFactory.createMap(CayennePath.of(name), expression, keyType, entityType);
    }

    public static <K, V extends Persistent> MapProperty<K, V> createMap(CayennePath path, Class<K> keyType, Class<V> entityType) {
        return PropertyFactory.createMap(path, null, keyType, entityType);
    }

    public static <K, V extends Persistent> MapProperty<K, V> createMap(String name, Class<K> keyType, Class<V> entityType) {
        return PropertyFactory.createMap(CayennePath.of(name), null, keyType, entityType);
    }

    public static <T extends EmbeddableObject> EmbeddableProperty<T> createEmbeddable(CayennePath path, Expression exp, Class<T> embeddableType) {
        return new EmbeddableProperty<T>(path, exp, embeddableType);
    }

    public static <T extends EmbeddableObject> EmbeddableProperty<T> createEmbeddable(String name, Expression exp, Class<T> embeddableType) {
        return PropertyFactory.createEmbeddable(CayennePath.of(name), exp, embeddableType);
    }

    public static <T extends EmbeddableObject> EmbeddableProperty<T> createEmbeddable(CayennePath path, Class<T> embeddableType) {
        return PropertyFactory.createEmbeddable(path, null, embeddableType);
    }

    public static <T extends EmbeddableObject> EmbeddableProperty<T> createEmbeddable(String name, Class<T> embeddableType) {
        return PropertyFactory.createEmbeddable(CayennePath.of(name), null, embeddableType);
    }

    public static <T> BaseIdProperty<T> createBaseId(String attribute, CayennePath path, String entityName, Class<T> propertyType) {
        return new BaseIdProperty<T>(attribute, path, entityName, propertyType);
    }

    public static <T> BaseIdProperty<T> createBaseId(String attribute, String path, String entityName, Class<T> propertyType) {
        return PropertyFactory.createBaseId(attribute, CayennePath.of(path), entityName, propertyType);
    }

    public static <T> BaseIdProperty<T> createBaseId(String attribute, String entityName, Class<T> propertyType) {
        return PropertyFactory.createBaseId(attribute, CayennePath.EMPTY_PATH, entityName, propertyType);
    }

    public static <T extends Number> NumericIdProperty<T> createNumericId(String attribute, CayennePath path, String entityName, Class<T> propertyType) {
        return new NumericIdProperty<T>(attribute, path, entityName, propertyType);
    }

    public static <T extends Number> NumericIdProperty<T> createNumericId(String attribute, String entityName, Class<T> propertyType) {
        return PropertyFactory.createNumericId(attribute, CayennePath.EMPTY_PATH, entityName, propertyType);
    }

    public static <T extends Number> NumericIdProperty<T> createNumericId(String attribute, String path, String entityName, Class<T> propertyType) {
        return PropertyFactory.createNumericId(attribute, CayennePath.of(path), entityName, propertyType);
    }
}

