/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Set;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.property.CollectionProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;

public class SetProperty<V extends Persistent>
extends CollectionProperty<V, Set<V>> {
    protected SetProperty(CayennePath path, Expression expression, Class<V> entityType) {
        super(path, expression, Set.class, entityType);
    }

    @Override
    public SetProperty<V> alias(String alias) {
        ASTPath exp = PropertyUtils.createPathExp(this.getPath(), alias, this.getExpression().getPathAliases());
        return PropertyFactory.createSet(exp.getPath(), (Expression)exp, this.getEntityType());
    }

    @Override
    public SetProperty<V> outer() {
        CayennePathSegment last = this.getPath().last();
        if (last.isOuterJoin()) {
            return this;
        }
        CayennePath outerPath = this.getPath().parent().dot(last.outer());
        return PropertyFactory.createSet(outerPath, this.getEntityType());
    }

    @Override
    public SetProperty<V> enclosing() {
        return PropertyFactory.createSet(CayennePath.EMPTY_PATH, ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getEntityType());
    }
}

