/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.ModelerUtil;

class GeneratorsPanel
extends JPanel {
    private final DataMap dataMap;
    private final Class<?> type;
    private final String icon;
    private JCheckBox checkConfig;
    private JButton toConfigButton;

    GeneratorsPanel(DataMap dataMap, String icon, Class<?> type) {
        this.type = type;
        this.icon = icon;
        this.dataMap = dataMap;
        this.initView();
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        FormLayout layout = new FormLayout("left:pref, 4dlu, fill:70dlu, 3dlu, fill:120, 3dlu, fill:120", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.checkConfig = new JCheckBox();
        JLabel dataMapLabel = new JLabel(this.dataMap.getName());
        dataMapLabel.setToolTipText(this.dataMap.getName());
        DataChannelMetaData metaData = Application.getInstance().getMetaData();
        this.toConfigButton = new JButton("Edit Config");
        if (metaData.get(this.dataMap, this.type) == null && this.type == ReverseEngineering.class) {
            this.checkConfig.setEnabled(false);
        }
        this.toConfigButton.setIcon(ModelerUtil.buildIcon(this.icon));
        builder.append(this.checkConfig, (Component)dataMapLabel, (Component)this.toConfigButton);
        this.add((Component)builder.getPanel(), "Center");
    }

    JCheckBox getCheckConfig() {
        return this.checkConfig;
    }

    JButton getToConfigButton() {
        return this.toConfigButton;
    }

    DataMap getDataMap() {
        return this.dataMap;
    }
}

