/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.event;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;

public class TablePopupHandler
extends MouseAdapter {
    private final JTable table;
    private final JPopupMenu popup;

    public TablePopupHandler(JTable table, JPopupMenu popup) {
        this.table = table;
        this.popup = popup;
    }

    public static void install(JTable table, JPopupMenu popup) {
        table.addMouseListener(new TablePopupHandler(table, popup));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        this.table.editingCanceled(new ChangeEvent(this));
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1 && !this.table.getSelectionModel().isSelectedIndex(row)) {
            this.table.setRowSelectionInterval(row, row);
        }
        this.popup.show(this.table, e.getX(), e.getY());
    }
}

