/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.util.state.DisplayEventType;

class EmbeddableDisplayEventType
extends DisplayEventType {
    public EmbeddableDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Embeddable embeddable = dataMap.getEmbeddable(this.preferences.getEmbeddable());
        if (embeddable == null) {
            return;
        }
        EmbeddableDisplayEvent embeddableDisplayEvent = new EmbeddableDisplayEvent((Object)this, embeddable, dataMap, dataChannel);
        this.controller.fireEmbeddableDisplayEvent(embeddableDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(EmbeddableDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        this.preferences.setEmbeddable(this.controller.getCurrentEmbeddable().getClassName());
    }
}

