/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.handlers;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpgradeHandler_V9
implements UpgradeHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeHandler_V9.class);

    @Override
    public String getVersion() {
        return "9";
    }

    @Override
    public void processProjectDom(UpgradeUnit upgradeUnit) {
        Element domain = upgradeUnit.getDocument().getDocumentElement();
        domain.setAttribute("project-version", this.getVersion());
    }

    @Override
    public void processDataMapDom(UpgradeUnit upgradeUnit) {
        Document document = upgradeUnit.getDocument();
        Element dataMap = document.getDocumentElement();
        this.updateDataMapSchemaAndVersion(upgradeUnit);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node reNode = (Node)xpath.evaluate("/data-map/reverse-engineering-config", document, XPathConstants.NODE);
            if (reNode != null) {
                String reFileName = ((Element)reNode).getAttribute("name") + ".xml";
                String directoryPath = Util.toFile(upgradeUnit.getResource().getURL()).getParent();
                File file = new File(directoryPath + "/" + reFileName);
                if (file.exists() && !file.delete()) {
                    logger.warn("Can't delete file " + String.valueOf(file));
                }
                dataMap.removeChild(reNode);
            }
        }
        catch (Exception ex) {
            logger.warn("Can't process dataMap DOM: ", ex);
        }
    }
}

