/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class EmbeddableValidator
extends ConfigurationNodeValidator<Embeddable> {
    public EmbeddableValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(Embeddable node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.EMBEDDABLE_NO_NAME, this::checkForName).performIfEnabled(Inspection.EMBEDDABLE_NAME_DUPLICATE, this::checkForNameDuplicates);
    }

    private void checkForName(Embeddable embeddable, ValidationResult validationResult) {
        String name = embeddable.getClassName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, embeddable, "Unnamed Embeddable", new Object[0]);
        }
    }

    private void checkForNameDuplicates(Embeddable embeddable, ValidationResult validationResult) {
        DataChannelDescriptor domain;
        String name = embeddable.getClassName();
        DataMap map = embeddable.getDataMap();
        if (map == null || Util.isEmptyString(name)) {
            return;
        }
        for (Embeddable otherEmb : map.getEmbeddables()) {
            if (otherEmb == embeddable || !name.equals(otherEmb.getClassName())) continue;
            this.addFailure(validationResult, embeddable, "Duplicate Embeddable class name: %s", name);
            break;
        }
        if ((domain = map.getDataChannelDescriptor()) == null) {
            return;
        }
        for (DataMap nextMap : domain.getDataMaps()) {
            Embeddable conflictingEmbeddable;
            if (nextMap == map || (conflictingEmbeddable = nextMap.getEmbeddable(name)) == null || conflictingEmbeddable == embeddable) continue;
            this.addFailure(validationResult, embeddable, "Duplicate Embeddable name in another DataMap: %s", name);
            break;
        }
    }
}

