/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureQueryValidator
extends BaseQueryValidator<ProcedureQueryDescriptor> {
    public ProcedureQueryValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    protected ConfigurationNodeValidator.Performer<ProcedureQueryDescriptor> validateQuery(ProcedureQueryDescriptor query, ValidationResult validationResult) {
        return super.validateQuery(query, validationResult).performIfEnabled(Inspection.PROCEDURE_QUERY_NO_ROOT, this::checkForRoot).performIfEnabled(Inspection.PROCEDURE_QUERY_INVALID_ROOT, this::validateRoot);
    }

    private void checkForRoot(ProcedureQueryDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        Object root = query.getRoot();
        if (root == null && map != null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has no root", query.getName());
        }
    }

    private void validateRoot(ProcedureQueryDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        Object root = query.getRoot();
        if (root == null) {
            return;
        }
        if (root instanceof Procedure) {
            Procedure procedure = (Procedure)root;
            if (map != null && map.getProcedure(procedure.getName()) != procedure) {
                this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), procedure.getName());
            }
        } else if (root instanceof String && map != null && map.getProcedure(root.toString()) == null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), root);
        }
    }
}

