/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;

public class LazyBytesTransformerFactory
implements BytesTransformerFactory {
    private Provider<BytesTransformerFactory> delegateProvider;
    private volatile BytesTransformerFactory delegate;

    public LazyBytesTransformerFactory(@Inject Provider<BytesTransformerFactory> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public BytesEncryptor encryptor() {
        return this.ensureInit().encryptor();
    }

    @Override
    public BytesDecryptor decryptor() {
        return this.ensureInit().decryptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesTransformerFactory ensureInit() {
        if (this.delegate == null) {
            LazyBytesTransformerFactory lazyBytesTransformerFactory = this;
            synchronized (lazyBytesTransformerFactory) {
                if (this.delegate == null) {
                    this.delegate = (BytesTransformerFactory)this.delegateProvider.get();
                }
            }
        }
        return this.delegate;
    }
}

