/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;

public class EffectiveOpId {
    private static final int MAX_NESTED_SUPPLIER_LEVEL = 1000;
    private final String entityName;
    private final Map<String, Object> snapshot;
    private final ObjectId id;

    public EffectiveOpId(ObjectId id) {
        this(id, id.getEntityName(), id.getIdSnapshot());
    }

    public EffectiveOpId(String entityName, ObjectId id) {
        this(id, entityName, id.getIdSnapshot());
    }

    public EffectiveOpId(String entityName, Map<String, Object> idSnapshot) {
        this(null, entityName, idSnapshot);
    }

    private EffectiveOpId(ObjectId id, String entityName, Map<String, Object> idSnapshot) {
        this.entityName = entityName;
        if (idSnapshot.size() == 1 && !(idSnapshot.values().iterator().next() instanceof Supplier)) {
            this.snapshot = idSnapshot;
        } else {
            this.snapshot = new HashMap<String, Object>(idSnapshot.size());
            idSnapshot.forEach((key, value) -> {
                int safeguard;
                Object initial = value;
                for (safeguard = 0; value instanceof Supplier && safeguard < 1000; ++safeguard) {
                    value = ((Supplier)value).get();
                }
                if (safeguard == 1000) {
                    throw new CayenneRuntimeException("Possible recursive supplier chain for PK value: key '%s'", key);
                }
                if (value != null) {
                    this.snapshot.put((String)key, value);
                } else {
                    this.snapshot.put((String)key, initial);
                }
            });
        }
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectiveOpId that = (EffectiveOpId)o;
        if (this.id == that.id) {
            return true;
        }
        if (this.snapshot.isEmpty()) {
            return false;
        }
        if (!this.entityName.equals(that.entityName)) {
            return false;
        }
        return this.snapshot.equals(that.snapshot);
    }

    public int hashCode() {
        int result = this.entityName.hashCode();
        result = 31 * result + this.snapshot.hashCode();
        return result;
    }

    public String toString() {
        return "EffectiveOpId{" + this.entityName + ": " + String.valueOf(this.snapshot) + "}";
    }
}

