/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.TableTreeNode;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;

class TableTree {
    private final Map<CayennePath, TableTreeNode> tableNodes;
    private final TableTree parentTree;
    private final TableTreeNode rootNode;
    private int tableAliasSequence = 0;

    TableTree(DbEntity root, TableTree parentTree) {
        this.parentTree = parentTree;
        this.tableNodes = new LinkedHashMap<CayennePath, TableTreeNode>();
        this.rootNode = new TableTreeNode(root, this.nextTableAlias());
    }

    void addJoinTable(CayennePath path, DbRelationship relationship, JoinType joinType) {
        this.addJoinTable(path, relationship, joinType, null);
    }

    void addJoinTable(CayennePath path, DbRelationship relationship, JoinType joinType, Expression additionalQualifier) {
        TableTreeNode treeNode = this.tableNodes.get(path);
        if (treeNode != null) {
            return;
        }
        TableTreeNode node = new TableTreeNode(path, relationship, this.nextTableAlias(), joinType, additionalQualifier);
        this.tableNodes.put(path, node);
    }

    String aliasForPath(CayennePath attributePath) {
        if (attributePath.isEmpty()) {
            return this.rootNode.getTableAlias();
        }
        TableTreeNode node = this.tableNodes.get(attributePath);
        if (node == null) {
            throw new CayenneRuntimeException("No table for attribute '%s' found", attributePath);
        }
        return node.getTableAlias();
    }

    String nextTableAlias() {
        if (this.parentTree != null) {
            return this.parentTree.nextTableAlias();
        }
        return "t" + String.valueOf(this.tableAliasSequence++);
    }

    public int getNodeCount() {
        return this.tableNodes.size() + 1;
    }

    boolean hasToManyJoin() {
        if (this.getNodeCount() <= 1) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.visit(node -> {
            if (node.getRelationship() != null && node.getRelationship().isToMany()) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    public void visit(TableNodeVisitor visitor) {
        visitor.visit(this.rootNode);
        int initialSize = 0;
        int currentSize = this.tableNodes.size();
        while (initialSize != currentSize) {
            this.tableNodes.values().stream().skip(initialSize).collect(Collectors.toList()).forEach(visitor::visit);
            initialSize = currentSize;
            currentSize = this.tableNodes.size();
        }
    }

    @FunctionalInterface
    static interface TableNodeVisitor {
        public void visit(TableTreeNode var1);
    }
}

