/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.event;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.apache.cayenne.modeler.util.CayenneTable;

public class TablePopupHandler
extends MouseAdapter {
    private final CayenneTable table;
    private final JPopupMenu popup;

    public TablePopupHandler(CayenneTable table, JPopupMenu popup) {
        this.table = table;
        this.popup = popup;
    }

    public static void install(CayenneTable table, JPopupMenu popup) {
        table.addMouseListener(new TablePopupHandler(table, popup));
    }

    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.table.cancelEditing();
            int row = this.table.rowAtPoint(e.getPoint());
            if (row != -1 && !this.table.getSelectionModel().isSelectedIndex(row)) {
                this.table.setRowSelectionInterval(row, row);
            }
            this.popup.show(this.table, e.getX(), e.getY());
        }
    }
}

