/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.Properties;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.DomainPreference;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.util.Util;

public class PreferenceDetail
extends CayenneDataObject {
    protected DomainPreference domainPreference;

    public void rename(String newKey) {
        if (Util.nullSafeEquals((Object)this.getKey(), (Object)newKey)) {
            return;
        }
        DomainPreference domainPrefrence = this.getDomainPreference();
        Domain parent = domainPrefrence.getDomain();
        if (parent == null) {
            domainPrefrence.setKey(newKey);
            return;
        }
        DomainPreference other = parent.getDomainPreference(newKey);
        if (other != null && other != domainPrefrence) {
            String otherName = null;
            for (int i = 1; i < 1000; ++i) {
                if (parent.getDomainPreference(newKey + i) != null) continue;
                otherName = newKey + i;
                break;
            }
            if (otherName == null) {
                throw new PreferenceException("Can't rename an existing preference '" + newKey + "'.");
            }
            other.setKey(otherName);
        }
        domainPrefrence.setKey(newKey);
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new PreferenceException("Error converting to int: " + value);
        }
    }

    public String getKey() {
        if (this.getDomainPreference() == null) {
            throw new PreferenceException("Preference not initialized, can't work with properties.");
        }
        return this.domainPreference.getKey();
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    public boolean getBooleanProperty(String key) {
        return "true".equalsIgnoreCase(this.getProperty(key));
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, "" + value);
    }

    public DomainPreference getDomainPreference() {
        ObjectContext context;
        if (this.domainPreference == null && (context = this.getObjectContext()) != null && this.getObjectId() != null) {
            int pk = DataObjectUtils.intPKForObject((Persistent)this);
            this.domainPreference = (DomainPreference)((Object)DataObjectUtils.objectForPK((ObjectContext)context, DomainPreference.class, (int)pk));
        }
        return this.domainPreference;
    }

    public void setDomainPreference(DomainPreference domainPreference) {
        if (this.domainPreference != domainPreference) {
            this.domainPreference = domainPreference;
            ObjectId oid = this.getObjectId();
            if (oid != null && oid.isTemporary()) {
                oid.getReplacementIdMap().put("id", new Integer(this.buildPermanentId()));
            }
        }
    }

    protected Properties getProperties() {
        if (this.getDomainPreference() == null) {
            throw new PreferenceException("Preference not initialized, can't work with properties.");
        }
        return this.domainPreference.getProperties();
    }

    protected int buildPermanentId() {
        ObjectId otherId = this.getDomainPreference().getObjectId();
        if (otherId == null) {
            throw new PreferenceException("Can't persist preference. DomainPreference has no ObjectId");
        }
        if (otherId.isTemporary() && !otherId.isReplacementIdAttached()) {
            DbEntity entity = this.getObjectContext().getEntityResolver().lookupDbEntity((Persistent)this.domainPreference);
            DataNode node = ((DataContext)this.getObjectContext()).getParentDataDomain().lookupDataNode(entity.getDataMap());
            try {
                Object pk = node.getAdapter().getPkGenerator().generatePk(node, (DbAttribute)entity.getPrimaryKeys().iterator().next());
                otherId.getReplacementIdMap().put("id", pk);
            }
            catch (Throwable th) {
                throw new PreferenceException("Error creating primary key", Util.unwindException((Throwable)th));
            }
        }
        return DataObjectUtils.intPKForObject((Persistent)this.domainPreference);
    }
}

