/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.swing.BindingException;

public class BeanActionBinding
extends BindingBase {
    protected Component view;

    public BeanActionBinding(Component component, String actionExpression) {
        boolean foundActionEvents;
        block4: {
            super(actionExpression);
            this.view = component;
            foundActionEvents = false;
            try {
                BeanInfo info = Introspector.getBeanInfo(component.getClass());
                EventSetDescriptor[] events = info.getEventSetDescriptors();
                if (events == null || events.length <= 0) break block4;
                for (EventSetDescriptor event : events) {
                    if (!ActionListener.class.isAssignableFrom(event.getListenerType())) continue;
                    event.getAddListenerMethod().invoke((Object)component, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            BeanActionBinding.this.fireAction();
                        }
                    });
                    foundActionEvents = true;
                    break;
                }
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error binding to component", (Throwable)e);
            }
        }
        if (!foundActionEvents) {
            throw new CayenneRuntimeException("Component does not define action events: " + component);
        }
    }

    public Component getView() {
        if (this.view == null) {
            throw new BindingException("headless action");
        }
        return this.view;
    }

    public void updateView() {
    }

    protected void fireAction() {
        this.getValue();
    }
}

