/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.select.CompoundSelectDescriptor;
import org.apache.cayenne.access.select.EntitySegmentBuilder;
import org.apache.cayenne.access.select.EntityTreeSegmentBuilder;
import org.apache.cayenne.access.select.ScalarSegmentBuilder;
import org.apache.cayenne.access.select.SelectDescriptor;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDescriptorBuilder {
    private ExtendedTypeMap extendedTypes;
    private transient ScalarSegmentBuilder scalarSegmentBuilder;

    public SelectDescriptorBuilder(ExtendedTypeMap extendedTypes) {
        this.extendedTypes = extendedTypes;
    }

    public SelectDescriptor<?> fromQueryMetadata(QueryMetadata metadata) {
        int segmentsCount;
        List<Object> segmentMap = metadata.getResultSetMapping();
        int n = segmentsCount = segmentMap != null ? segmentMap.size() : 1;
        if (segmentsCount == 0) {
            throw new CayenneRuntimeException("Empty result descriptor");
        }
        int entitySegments = 0;
        int scalarSegments = 0;
        SelectDescriptor[] segments = new SelectDescriptor[segmentsCount];
        if (segmentMap == null) {
            segments[0] = this.getEntitySegment(metadata, null, 0);
            ++entitySegments;
        } else {
            for (int i = 0; i < segmentsCount; ++i) {
                Object segmentDescriptor = segmentMap.get(i);
                if (segmentDescriptor instanceof EntityResultSegment) {
                    segments[i] = this.getEntitySegment(metadata, (EntityResultSegment)segmentDescriptor, i);
                    ++entitySegments;
                    continue;
                }
                segments[i] = this.getScalarSegment(segmentMap, i);
                ++scalarSegments;
            }
        }
        if (metadata.getPageSize() > 0 && (entitySegments != 1 || scalarSegments != 0)) {
            throw new CayenneRuntimeException("Paginated queries are only supported for a single entity result");
        }
        if (segmentsCount == 1) {
            return segments[0];
        }
        return new CompoundSelectDescriptor(segments);
    }

    protected SelectDescriptor<Object> getEntitySegment(QueryMetadata metadata, EntityResultSegment segmentDescriptor, int position) {
        ClassDescriptor classDescriptor;
        List<Object> segmentDesriptors = metadata.getResultSetMapping();
        if (segmentDesriptors != null) {
            EntityResultSegment segmentMetadata = (EntityResultSegment)segmentDesriptors.get(position);
            classDescriptor = segmentMetadata.getClassDescriptor();
        } else {
            Object segmentMetadata = null;
            classDescriptor = metadata.getClassDescriptor();
        }
        if (classDescriptor == null) {
            DbEntity dbEntity = metadata.getDbEntity();
            if (dbEntity == null) {
                throw new CayenneRuntimeException("Invalid entity segment in position " + position + ", no root DbEntity specified");
            }
            throw new UnsupportedOperationException("TODO: DbEntity based queries");
        }
        if (classDescriptor.getEntityInheritanceTree() != null || classDescriptor.getSuperclassDescriptor() != null) {
            return new EntityTreeSegmentBuilder(metadata, this.extendedTypes, classDescriptor).buildSegment();
        }
        return new EntitySegmentBuilder(metadata, this.extendedTypes, classDescriptor.getEntity()).buildSegment();
    }

    protected SelectDescriptor<Object> getScalarSegment(List<Object> segmentDescriptors, int position) {
        if (this.scalarSegmentBuilder == null) {
            this.scalarSegmentBuilder = new ScalarSegmentBuilder(this.extendedTypes, segmentDescriptors);
        }
        return this.scalarSegmentBuilder.getSegment(position);
    }
}

