/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.layout.BorderVertex;
import org.objectstyle.ashwood.graph.layout.LayerVertex;
import org.objectstyle.ashwood.graph.layout.NestingTreeNode;
import org.objectstyle.ashwood.graph.layout.VertexSegment;

public class NestedSubgraph
implements NestingTreeNode {
    private List children;
    private VertexSegment leftBorder;
    private VertexSegment rightBorder;
    private int minRank = Integer.MAX_VALUE;
    private int maxRank = Integer.MIN_VALUE;
    private NestedSubgraph parentSubgraph;
    private int vertexCount;
    private double position;
    private Map layerPositions = new HashMap(3);
    private Map layerVertexCounts = new HashMap(3);
    private String label;

    public NestedSubgraph() {
        this.children = new ArrayList();
    }

    public NestedSubgraph(int capacity) {
        this.children = new ArrayList(capacity);
    }

    public boolean contains(LayerVertex vertex) {
        return this.children.contains(vertex);
    }

    public boolean contains(NestedSubgraph subgraph) {
        return this.children.contains(subgraph);
    }

    public boolean add(LayerVertex vertex) {
        int rank = vertex.getRank();
        this.minRank = Math.min(this.minRank, rank);
        this.maxRank = Math.max(this.maxRank, rank);
        vertex.setParentSubgraph(this);
        return this.children.add(vertex);
    }

    public boolean add(NestedSubgraph subgraph) {
        this.minRank = Math.min(this.minRank, subgraph.getMinRank());
        this.maxRank = Math.max(this.maxRank, subgraph.getMaxRank());
        subgraph.setParentSubgraph(this);
        return this.children.add(subgraph);
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void createBorders() {
        this.leftBorder = new VertexSegment();
        this.rightBorder = new VertexSegment();
        LayerVertex leftPredecessor = null;
        LayerVertex rightPredecessor = null;
        for (int i = this.minRank; i <= this.maxRank; ++i) {
            BorderVertex lv = new BorderVertex();
            this.leftBorder.add(lv);
            this.children.add(lv);
            lv.setParentSubgraph(this);
            lv.setRank(i);
            if (leftPredecessor != null) {
                leftPredecessor.getSuccessors().add(lv);
                lv.getPredecessors().add(leftPredecessor);
            }
            leftPredecessor = lv;
            BorderVertex rv = new BorderVertex();
            this.rightBorder.add(rv);
            this.children.add(rv);
            rv.setParentSubgraph(this);
            rv.setRank(i);
            if (rightPredecessor != null) {
                rightPredecessor.getSuccessors().add(rv);
                rv.getPredecessors().add(rightPredecessor);
            }
            rightPredecessor = rv;
        }
    }

    public double layerPosition(ArrayList layer) {
        double position = 0.0;
        int count = 0;
        for (int i = 0; i < layer.size(); ++i) {
            if (!this.children.contains(layer.get(i))) continue;
            position += (double)i;
            ++count;
        }
        position = count > 0 ? position / (double)count : -1.0;
        return position;
    }

    public double position(ArrayList[] layers) {
        double position = 0.0;
        int count = 0;
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].size(); ++j) {
                if (!this.children.contains(layers[i].get(j))) continue;
                position += (double)j;
                ++count;
            }
        }
        position = count > 0 ? position / (double)count : -1.0;
        return position;
    }

    public boolean isLeftOf(NestedSubgraph subgraph, ArrayList[] layers) {
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].size() - 1; ++j) {
                if (!this.children.contains(layers[i].get(j)) || !subgraph.children.contains(layers[i].get(j + 1))) continue;
                return true;
            }
        }
        return false;
    }

    public int getMaxRank() {
        return this.maxRank;
    }

    public int getMinRank() {
        return this.minRank;
    }

    public VertexSegment getRightBorder() {
        return this.rightBorder;
    }

    public VertexSegment getLeftBorder() {
        return this.leftBorder;
    }

    public LayerVertex getLeftBorderVertex(int rank) {
        return this.leftBorder.getVertex(rank - this.minRank);
    }

    public LayerVertex getRightBorderVertex(int rank) {
        return this.rightBorder.getVertex(rank - this.minRank);
    }

    public void setParentSubgraph(NestedSubgraph parentSubgraph) {
        this.parentSubgraph = parentSubgraph;
    }

    public NestedSubgraph getParentSubgraph() {
        return this.parentSubgraph;
    }

    public double getPosition() {
        return this.position;
    }

    public int countVertices(int rank) {
        int count = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            NestingTreeNode child = (NestingTreeNode)this.children.get(i);
            count += child.countVertices(rank);
        }
        this.layerVertexCounts.put(new Integer(rank), new Integer(count));
        return count;
    }

    public double computePosition(int rank) {
        int count = this.countVertices(rank);
        if (count == 0) {
            return Double.NaN;
        }
        double p = 0.0;
        for (int i = 0; i < this.children.size(); ++i) {
            NestingTreeNode child = (NestingTreeNode)this.children.get(i);
            double childPosition = child.computePosition(rank);
            if (Double.isNaN(childPosition)) continue;
            p += (double)child.getVertexCount(rank) * childPosition;
        }
        this.layerPositions.put(new Integer(rank), new Double(p /= (double)count));
        return p;
    }

    public int countVertices() {
        this.vertexCount = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            NestingTreeNode child = (NestingTreeNode)this.children.get(i);
            this.vertexCount += child.countVertices();
        }
        return this.vertexCount;
    }

    public double getPosition(int rank) {
        Double p = (Double)this.layerPositions.get(new Integer(rank));
        return p != null ? p : Double.NaN;
    }

    public int getVertexCount(int rank) {
        Integer count = (Integer)this.layerVertexCounts.get(new Integer(rank));
        return count != null ? count : 0;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public double computePosition() {
        int count = this.countVertices();
        if (count == 0) {
            this.position = Double.NaN;
            return Double.NaN;
        }
        this.position = 0.0;
        for (int i = 0; i < this.children.size(); ++i) {
            NestingTreeNode child = (NestingTreeNode)this.children.get(i);
            double childPosition = child.computePosition();
            if (Double.isNaN(childPosition)) continue;
            this.position += (double)child.getVertexCount() * childPosition;
        }
        this.position /= (double)count;
        return this.position;
    }

    public int reindex(int rank, int firstIndex) {
        return this.reindex(rank, firstIndex, new PositionComparator(rank), new PositionPredicate(rank));
    }

    public int reindex(int rank, int firstIndex, Comparator comparator, Predicate predicate) {
        ArrayList<NestingTreeNode> traversalOrder = new ArrayList<NestingTreeNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            NestingTreeNode child = (NestingTreeNode)this.children.get(i);
            if (!child.includesRank(rank)) continue;
            traversalOrder.add(child);
        }
        Collections.sort(traversalOrder, comparator);
        for (NestingTreeNode child : traversalOrder) {
            firstIndex = child.reindex(rank, firstIndex, comparator, predicate);
            if (!(child instanceof LayerVertex)) continue;
            LayerVertex v = (LayerVertex)child;
        }
        return firstIndex;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean includesRank(int rank) {
        return this.minRank <= rank && rank <= this.maxRank;
    }

    public static class PositionPredicate
    implements Predicate {
        private int rank = -1;

        public PositionPredicate() {
        }

        public PositionPredicate(int rank) {
            this.rank = rank;
        }

        public boolean evaluate(Object o) {
            NestingTreeNode node = (NestingTreeNode)o;
            if (this.rank < 0) {
                return !Double.isNaN(node.getPosition());
            }
            return !Double.isNaN(node.getPosition(this.rank));
        }
    }

    public static class PositionComparator
    implements Comparator {
        private int rank = -1;

        public PositionComparator() {
        }

        public PositionComparator(int rank) {
            this.rank = rank;
        }

        public int compare(Object o1, Object o2) {
            NestingTreeNode node1 = (NestingTreeNode)o1;
            NestingTreeNode node2 = (NestingTreeNode)o2;
            if (this.rank < 0) {
                return Double.compare(node1.getPosition(), node2.getPosition());
            }
            return Double.compare(node1.getPosition(this.rank), node2.getPosition(this.rank));
        }
    }
}

