/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.BindDirective;
import org.apache.cayenne.access.jdbc.BindEqualDirective;
import org.apache.cayenne.access.jdbc.BindNotEqualDirective;
import org.apache.cayenne.access.jdbc.BindObjectEqualDirective;
import org.apache.cayenne.access.jdbc.BindObjectNotEqualDirective;
import org.apache.cayenne.access.jdbc.ChainDirective;
import org.apache.cayenne.access.jdbc.ChunkDirective;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.access.jdbc.ResultDirective;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateRenderingUtils;
import org.apache.cayenne.access.jdbc.SQLTemplateResourceManager;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;

class SQLTemplateProcessor {
    private static RuntimeInstance sharedRuntime;
    static final String BINDINGS_LIST_KEY = "bindings";
    static final String RESULT_COLUMNS_LIST_KEY = "resultColumns";
    static final String HELPER_KEY = "helper";
    private static final SQLTemplateRenderingUtils sharedUtils;
    RuntimeInstance velocityRuntime;
    SQLTemplateRenderingUtils renderingUtils;

    private static void initVelocityRuntime() {
        sharedRuntime = new RuntimeInstance();
        sharedRuntime.addProperty("runtime.log.logsystem", new NullLogSystem());
        sharedRuntime.addProperty("resource.manager.class", SQLTemplateResourceManager.class.getName());
        sharedRuntime.addProperty("userdirective", BindDirective.class.getName());
        sharedRuntime.addProperty("userdirective", BindEqualDirective.class.getName());
        sharedRuntime.addProperty("userdirective", BindNotEqualDirective.class.getName());
        sharedRuntime.addProperty("userdirective", BindObjectEqualDirective.class.getName());
        sharedRuntime.addProperty("userdirective", BindObjectNotEqualDirective.class.getName());
        sharedRuntime.addProperty("userdirective", ResultDirective.class.getName());
        sharedRuntime.addProperty("userdirective", ChainDirective.class.getName());
        sharedRuntime.addProperty("userdirective", ChunkDirective.class.getName());
        try {
            sharedRuntime.init();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error setting up Velocity RuntimeInstance.", ex);
        }
    }

    SQLTemplateProcessor() {
        this.velocityRuntime = sharedRuntime;
        this.renderingUtils = sharedUtils;
    }

    SQLTemplateProcessor(RuntimeInstance velocityRuntime, SQLTemplateRenderingUtils renderingUtils) {
        this.velocityRuntime = velocityRuntime;
        this.renderingUtils = renderingUtils;
    }

    SQLStatement processTemplate(String template, Map parameters) throws Exception {
        HashMap<String, Object> internalParameters = parameters != null && !parameters.isEmpty() ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>(3);
        ArrayList bindings = new ArrayList();
        ArrayList results = new ArrayList();
        internalParameters.put(BINDINGS_LIST_KEY, bindings);
        internalParameters.put(RESULT_COLUMNS_LIST_KEY, results);
        internalParameters.put(HELPER_KEY, this.renderingUtils);
        String sql = this.buildStatement(new VelocityContext(internalParameters), template, parameters);
        ParameterBinding[] bindingsArray = new ParameterBinding[bindings.size()];
        bindings.toArray(bindingsArray);
        ColumnDescriptor[] resultsArray = new ColumnDescriptor[results.size()];
        results.toArray(resultsArray);
        return new SQLStatement(sql, resultsArray, bindingsArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String buildStatement(VelocityContext context, String template, Map parameters) throws Exception {
        StringWriter out = new StringWriter(template.length());
        SimpleNode nodeTree = null;
        try {
            nodeTree = this.velocityRuntime.parse(new StringReader(template), template);
        }
        catch (ParseException pex) {
            throw new CayenneRuntimeException("Error parsing template '" + template + "' : " + pex.getMessage());
        }
        if (nodeTree == null) {
            throw new CayenneRuntimeException("Error parsing template " + template);
        }
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
        ica.pushCurrentTemplateName(template);
        try {
            nodeTree.init(ica, this.velocityRuntime);
            nodeTree.render(ica, out);
            String string = out.toString();
            return string;
        }
        finally {
            ica.popCurrentTemplateName();
        }
    }

    static {
        sharedUtils = new SQLTemplateRenderingUtils();
        SQLTemplateProcessor.initVelocityRuntime();
    }
}

