/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.FileClassLoadingService;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceEditor;

public class ClasspathPreferences
extends CayenneController {
    protected ClasspathPreferencesView view;
    protected PreferenceEditor editor;
    protected List classPathEntries;
    protected ClasspathTableModel tableModel;

    public ClasspathPreferences(PreferenceDialog parentController) {
        super(parentController);
        this.editor = parentController.getEditor();
        this.view = new ClasspathPreferencesView();
        this.classPathEntries = this.getClassLoaderDomain().getDetails();
        this.tableModel = new ClasspathTableModel();
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    protected Domain getClassLoaderDomain() {
        return this.editor.editableInstance(this.getApplication().getPreferenceDomain()).getSubdomain(FileClassLoadingService.class);
    }

    protected void initBindings() {
        this.view.getTable().setModel(this.tableModel);
        this.view.getAddDirButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.addClassDirectoryAction();
            }
        });
        this.view.getRemoveEntryButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.removeEntryAction();
            }
        });
        this.view.getAddJarButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.addJarOrZipAction();
            }
        });
    }

    protected void addJarOrZipAction() {
        this.chooseClassEntry(FileFilters.getClassArchiveFilter(), "Select JAR or ZIP File.", 0);
    }

    protected void addClassDirectoryAction() {
        this.chooseClassEntry(null, "Select Java Class Directory.", 1);
    }

    protected void removeEntryAction() {
        int selected = this.view.getTable().getSelectedRow();
        if (selected < 0) {
            return;
        }
        PreferenceDetail selection = (PreferenceDetail)this.classPathEntries.remove(selected);
        this.editor.deleteDetail(this.getClassLoaderDomain(), selection.getKey());
        this.tableModel.fireTableRowsDeleted(selected, selected);
    }

    protected void chooseClassEntry(FileFilter filter, String title, int selectionMode) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogType(0);
        chooser.setAcceptAllFileFilterUsed(true);
        this.getLastDirectory().updateChooser(chooser);
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setDialogTitle(title);
        File selected = null;
        int result = chooser.showOpenDialog(this.view);
        if (result == 0) {
            selected = chooser.getSelectedFile();
        }
        if (selected != null) {
            this.getLastDirectory().updateFromChooser(chooser);
            int len = this.classPathEntries.size();
            String key = selected.getAbsolutePath();
            this.classPathEntries.add(this.editor.createDetail(this.getClassLoaderDomain(), key));
            this.tableModel.fireTableRowsInserted(len, len);
        }
    }

    class ClasspathTableModel
    extends AbstractTableModel {
        ClasspathTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return ClasspathPreferences.this.classPathEntries.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            PreferenceDetail preference = (PreferenceDetail)ClasspathPreferences.this.classPathEntries.get(rowIndex);
            return preference.getKey();
        }

        public String getColumnName(int column) {
            return "Custom ClassPath";
        }
    }
}

