/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.ConstAttribute;

public class BreadthFirstSearch
extends Algorithm {
    private DigraphIteration factory;
    private Collection firstVertices;
    private Buffer queue = new UnboundedFifoBuffer();
    private Set seen = new HashSet();
    private Attribute level;
    private boolean validTree;

    public BreadthFirstSearch(DigraphIteration factory, Object firstVertex) {
        this(factory, firstVertex, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public BreadthFirstSearch(DigraphIteration factory, Object firstVertex, Attribute level) {
        this.factory = factory;
        this.reset(firstVertex, level);
    }

    public BreadthFirstSearch(DigraphIteration factory, Collection firstVertices) {
        this(factory, firstVertices, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public BreadthFirstSearch(DigraphIteration factory, Collection firstVertices, Attribute level) {
        this.factory = factory;
        this.reset(firstVertices, level);
    }

    public void reset(Object newFirstVertex) {
        this.reset(newFirstVertex, (Attribute)new ConstAttribute(new Integer(-1)));
    }

    public void reset(Object newFirstVertex, Attribute level) {
        this.reset(Collections.singletonList(newFirstVertex), level);
    }

    public void reset(Collection newFirstVertices, Attribute level) {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
        }
        if (!this.seen.isEmpty()) {
            this.seen.clear();
        }
        this.firstVertices = newFirstVertices;
        this.level = level;
        this.queue.addAll(this.firstVertices);
        this.seen.addAll(this.firstVertices);
        Iterator i = this.firstVertices.iterator();
        while (i.hasNext()) {
            level.set(i.next(), new Integer(0));
        }
        this.validTree = true;
    }

    public Attribute getLevel() {
        return this.level;
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public Object next() {
        ArcIterator i = this.factory.outgoingIterator(this.queue.remove());
        Object origin = i.getOrigin();
        Integer childLevelValue = new Integer(this.level.get(origin).hashCode() + 1);
        while (i.hasNext()) {
            i.next();
            Object dst = i.getDestination();
            if (this.seen.add(dst)) {
                this.queue.add(dst);
                this.level.set(dst, childLevelValue);
                continue;
            }
            this.validTree = false;
        }
        return origin;
    }

    public Set getSeenVertices() {
        return Collections.unmodifiableSet(this.seen);
    }

    public boolean isValidTree() {
        return this.validTree;
    }
}

