/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.PropertyView;
import org.scopemvc.core.Selector;
import org.scopemvc.util.ScopeConfig;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.util.convertor.StringConvertors;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.util.ModelBindable;

public class SLabel
extends JLabel
implements PropertyView,
ModelBindable,
Refreshable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SLabel == null ? (class$org$scopemvc$view$swing$SLabel = SLabel.class$("org.scopemvc.view.swing.SLabel")) : class$org$scopemvc$view$swing$SLabel);
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private StringConvertor stringConvertor;
    private StringConvertor forcedStringConvertor;
    private boolean readOnly = false;
    private boolean userEnabled = true;
    private PropertyChangeListener enabledPropertyListener = null;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SLabel;

    public SLabel(String string, Icon icon, int n) {
        super(string, icon, n);
    }

    public SLabel(String string, int n) {
        this(string, null, n);
    }

    public SLabel(String string) {
        this(string, null, 10);
    }

    public SLabel(Icon icon, int n) {
        this(null, icon, n);
    }

    public SLabel(Icon icon) {
        this(null, icon, 0);
    }

    public SLabel() {
        this("", null, 10);
    }

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public Object getViewValue() throws IllegalArgumentException {
        String string = this.getText();
        if (this.stringConvertor == null) {
            return null;
        }
        return this.stringConvertor.stringAsValue(string);
    }

    public Controller getController() {
        return null;
    }

    public void issueControl(Control control) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can't issue a control from a SLabel");
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
        this.setupStringConvertor();
    }

    public void setEnabled(boolean bl) {
        this.userEnabled = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
        this.setupStringConvertor();
    }

    public void setSelector(String string) {
        this.boundModel.setSelector(string);
        this.setupStringConvertor();
    }

    public void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void setStringConvertor(StringConvertor stringConvertor) {
        this.stringConvertor = this.forcedStringConvertor = stringConvertor;
    }

    public void setText(String string) {
        if (!this.getText().equals(string)) {
            super.setText(string);
        }
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void setLabelFor(Component component) {
        Component component2 = this.getLabelFor();
        if (component2 != null && this.enabledPropertyListener != null) {
            component2.removePropertyChangeListener(this.enabledPropertyListener);
        }
        super.setLabelFor(component);
        if (component != null && "true".equals(ScopeConfig.getString("org.scopemvc.view.swing.SLabel.use_labelFor_component_enabled_state"))) {
            this.setReadOnly(!this.getLabelFor().isEnabled());
            if (this.enabledPropertyListener == null) {
                this.enabledPropertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        SLabel.this.setReadOnly(!SLabel.this.getLabelFor().isEnabled());
                    }
                };
            }
            component.addPropertyChangeListener("enabled", this.enabledPropertyListener);
        }
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl);
        }
        this.setupStringConvertor();
        if (this.stringConvertor == null) {
            if (this.getBoundModel() != null && object != null) {
                LOG.warn("No StringConvertor found for property " + Selector.asString(this.getSelector()) + " in model " + this.getBoundModel());
            }
            this.setText("");
            this.revalidate();
            return;
        }
        try {
            String string = this.stringConvertor.valueAsString(object);
            this.setText(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.error("updateFromProperty", illegalArgumentException);
        }
        this.revalidate();
    }

    public void validationFailed(Exception exception) {
    }

    public void validationSuccess() {
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
    }

    protected void setupStringConvertor() {
        if (this.stringConvertor != null) {
            return;
        }
        if (this.forcedStringConvertor != null) {
            this.stringConvertor = this.forcedStringConvertor;
            return;
        }
        this.stringConvertor = this.createDefaultStringConvertor();
    }

    protected void setReadOnly(boolean bl) {
        this.readOnly = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    protected StringConvertor createDefaultStringConvertor() {
        try {
            Object object = this.getBoundModel();
            Selector selector = this.getSelector();
            if (object != null) {
                Class clazz = this.boundModel.getPropertyManager().getPropertyClass(object, selector);
                return StringConvertors.forClass(clazz);
            }
        }
        catch (Exception exception) {
            LOG.warn("createDefaultStringConvertor", exception);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

