/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.view.swing.SAbstractListModel;
import org.scopemvc.view.swing.SSortTableModel;
import org.scopemvc.view.swing.STable;
import org.scopemvc.view.swing.STableModel;

public class SSortTable
extends STable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SSortTable == null ? (class$org$scopemvc$view$swing$SSortTable = SSortTable.class$("org.scopemvc.view.swing.SSortTable")) : class$org$scopemvc$view$swing$SSortTable);
    private SortHeaderCellRenderer headerRenderer = new SortHeaderCellRenderer();
    static /* synthetic */ Class class$org$scopemvc$view$swing$SSortTable;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SSortTable$SortHeaderCellRenderer;

    public SSortTable() {
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        this.getTableHeader().addMouseListener(new HeaderListener());
    }

    public int findIndexFor(Object object) {
        if (object == null) {
            return -1;
        }
        SSortTableModel sSortTableModel = (SSortTableModel)this.getModel();
        int n = this.getModel().getRowCount() - 1;
        while (n >= 0) {
            int n2 = sSortTableModel.convertRowIndexToModel(n);
            if (object.equals(((SAbstractListModel)((Object)this.getModel())).getElementAt(n2))) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public Object findElementAt(int n) {
        if (n < 0) {
            return null;
        }
        try {
            int n2 = ((SSortTableModel)this.getModel()).convertRowIndexToModel(n);
            return ((SAbstractListModel)((Object)this.getModel())).getElementAt(n2);
        }
        catch (Exception exception) {
            LOG.warn("Can't findElementAt: " + n, exception);
            return null;
        }
    }

    public void sortByColumn(int n) {
        if (n == -1) {
            ((STableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
        } else {
            int n2 = this.convertColumnIndexToView(n);
            this.headerRenderer.setSelectedColumn(n2);
            this.getTableHeader().repaint();
            boolean bl = this.headerRenderer.isAscending(n2);
            ((SSortTableModel)this.getModel()).sortByColumn(n, bl);
        }
    }

    protected TableModel createDefaultDataModel() {
        return new SSortTableModel(this);
    }

    protected void resetHeader() {
        this.headerRenderer.setSelectedColumn(-1);
        this.getTableHeader().repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.getTable().isEditing()) {
                this.getTable().getCellEditor().stopCellEditing();
                if (this.getTable().isEditing()) {
                    return;
                }
            }
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            SSortTable.this.headerRenderer.setPressedColumn(n);
            this.getTable().getTableHeader().repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.getTable().isEditing()) {
                return;
            }
            SSortTable.this.headerRenderer.setPressedColumn(-1);
            this.getTable().getTableHeader().repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.getTable().isEditing()) {
                return;
            }
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            int n2 = this.getTable().convertColumnIndexToModel(n);
            if (n2 != -1) {
                SSortTable.this.sortByColumn(n2);
            }
        }

        private JTable getTable() {
            return SSortTable.this;
        }
    }

    private static class BevelArrowIcon
    implements Icon {
        public static final int UP = 0;
        public static final int DOWN = 1;
        private static final int DEFAULT_SIZE = 11;
        private Color edge1;
        private Color edge2;
        private Color fill;
        private int size;
        private int direction;

        public BevelArrowIcon(int n, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"), 11, n);
                } else {
                    this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), 11, n);
                }
            } else if (bl2) {
                this.init(UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), 11, n);
            } else {
                this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("control"), 11, n);
            }
        }

        public BevelArrowIcon(Color color, Color color2, Color color3, int n, int n2) {
            this.init(color, color2, color3, n, n2);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            switch (this.direction) {
                case 1: {
                    this.drawDownArrow(graphics, n, n2);
                    break;
                }
                case 0: {
                    this.drawUpArrow(graphics, n, n2);
                }
            }
        }

        private void init(Color color, Color color2, Color color3, int n, int n2) {
            this.edge1 = color;
            this.edge2 = color2;
            this.fill = color3;
            this.size = n;
            this.direction = n2;
        }

        private void drawDownArrow(Graphics graphics, int n, int n2) {
            graphics.setColor(this.edge1);
            graphics.drawLine(n, n2, n + this.size - 1, n2);
            graphics.drawLine(n, n2 + 1, n + this.size - 3, n2 + 1);
            graphics.setColor(this.edge2);
            graphics.drawLine(n + this.size - 2, n2 + 1, n + this.size - 1, n2 + 1);
            int n3 = n + 1;
            int n4 = n2 + 2;
            int n5 = this.size - 6;
            while (n4 + 1 < n2 + this.size) {
                graphics.setColor(this.edge1);
                graphics.drawLine(n3, n4, n3 + 1, n4);
                graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
                if (0 < n5) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
                }
                graphics.setColor(this.edge2);
                graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
                graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
                ++n3;
                n4 += 2;
                n5 -= 2;
            }
            graphics.setColor(this.edge1);
            graphics.drawLine(n + this.size / 2, n2 + this.size - 1, n + this.size / 2, n2 + this.size - 1);
        }

        private void drawUpArrow(Graphics graphics, int n, int n2) {
            graphics.setColor(this.edge1);
            int n3 = n + this.size / 2;
            graphics.drawLine(n3, n2, n3, n2);
            --n3;
            int n4 = n2 + 1;
            int n5 = 0;
            while (n4 + 3 < n2 + this.size) {
                graphics.setColor(this.edge1);
                graphics.drawLine(n3, n4, n3 + 1, n4);
                graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
                if (0 < n5) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
                }
                graphics.setColor(this.edge2);
                graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
                graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
                --n3;
                n4 += 2;
                n5 += 2;
            }
            graphics.setColor(this.edge1);
            graphics.drawLine(n, n2 + this.size - 3, n + 1, n2 + this.size - 3);
            graphics.setColor(this.edge2);
            graphics.drawLine(n + 2, n2 + this.size - 2, n + this.size - 1, n2 + this.size - 2);
            graphics.drawLine(n, n2 + this.size - 1, n + this.size, n2 + this.size - 1);
        }
    }

    static class DownState
    extends State {
        private JButton button;

        protected DownState() {
            super("Down");
            Insets insets = new Insets(0, 0, 0, 0);
            this.button = new JButton();
            this.button.setBorder(new BevelBorder(0));
            this.button.setMargin(insets);
            this.button.setHorizontalTextPosition(2);
            this.button.setIcon(new BevelArrowIcon(1, false, false));
            this.button.setPressedIcon(new BevelArrowIcon(1, false, true));
        }

        protected JButton getButton() {
            return this.button;
        }

        protected boolean isAscending() {
            return false;
        }
    }

    static class UpState
    extends State {
        private JButton button;

        protected UpState() {
            super("Up");
            Insets insets = new Insets(0, 0, 0, 0);
            this.button = new JButton();
            this.button.setBorder(new BevelBorder(0));
            this.button.setMargin(insets);
            this.button.setHorizontalTextPosition(2);
            this.button.setIcon(new BevelArrowIcon(0, false, false));
            this.button.setPressedIcon(new BevelArrowIcon(0, false, true));
        }

        protected JButton getButton() {
            return this.button;
        }

        protected boolean isAscending() {
            return true;
        }
    }

    static class NoneState
    extends State {
        private JButton button;

        protected NoneState() {
            super("None");
            Insets insets = new Insets(0, 0, 0, 0);
            this.button = new JButton();
            this.button.setBorder(new BevelBorder(0));
            this.button.setMargin(insets);
            this.button.setHorizontalTextPosition(2);
            this.button.setIcon(new BlankIcon());
        }

        protected JButton getButton() {
            return this.button;
        }

        protected boolean isAscending() {
            return true;
        }
    }

    static abstract class State {
        private State next;
        private String description;

        protected State(String string) {
            this.description = string;
        }

        public String toString() {
            return this.description + " state";
        }

        protected abstract JButton getButton();

        protected abstract boolean isAscending();

        protected void setNext(State state) {
            this.next = state;
        }

        protected State next() {
            return this.next;
        }
    }

    static class SortHeaderCellRenderer
    implements TableCellRenderer {
        private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SSortTable$SortHeaderCellRenderer == null ? (class$org$scopemvc$view$swing$SSortTable$SortHeaderCellRenderer = SSortTable.class$("org.scopemvc.view.swing.SSortTable$SortHeaderCellRenderer")) : class$org$scopemvc$view$swing$SSortTable$SortHeaderCellRenderer);
        private int pushedColumn = -1;
        private Map columnStates = new HashMap();
        private boolean active = true;
        private State noneState = new NoneState();
        private State upState = new UpState();
        private State downState = new DownState();

        public SortHeaderCellRenderer() {
            this.noneState.setNext(this.upState);
            this.upState.setNext(this.downState);
            this.downState.setNext(this.noneState);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            State state = this.noneState;
            if (this.active) {
                state = this.getState(n2);
            }
            JButton jButton = state.getButton();
            jButton.setText(object == null ? "" : object.toString());
            boolean bl3 = n2 == this.pushedColumn;
            jButton.getModel().setPressed(bl3);
            jButton.getModel().setArmed(bl3);
            return jButton;
        }

        public boolean isAscending(int n) {
            return this.getState(n).isAscending();
        }

        public void setFont(Font font) {
            this.noneState.getButton().setFont(font);
            this.upState.getButton().setFont(font);
            this.downState.getButton().setFont(font);
        }

        public void setPressedColumn(int n) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pressed column = " + n);
            }
            this.pushedColumn = n;
        }

        public void setSelectedColumn(int n) {
            Integer n2;
            State state;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selected column = " + n);
            }
            if (n < 0) {
                this.columnStates.clear();
            }
            if ((state = (State)this.columnStates.get(n2 = new Integer(n))) == null) {
                state = this.noneState;
            }
            this.columnStates.clear();
            this.columnStates.put(n2, state.next());
            if (LOG.isDebugEnabled()) {
                LOG.debug("New state: " + state.next());
            }
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        private State getState(int n) {
            State state = (State)this.columnStates.get(new Integer(n));
            if (state == null) {
                return this.noneState;
            }
            return state;
        }
    }

    public static class BlankIcon
    implements Icon {
        private Color fillColor;
        private int size;

        public BlankIcon() {
            this(null, 11);
        }

        public BlankIcon(Color color, int n) {
            this.fillColor = color;
            this.size = n;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.fillColor != null) {
                graphics.setColor(this.fillColor);
                graphics.drawRect(n, n2, this.size - 1, this.size - 1);
            }
        }
    }
}

