/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.LockingUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.PackageUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.SchemaUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.SuperclassUpdateController;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DataMapView
extends JPanel {
    protected ProjectController eventController;
    protected TextAdapter name;
    protected JLabel location;
    protected JComboBox nodeSelector;
    protected JCheckBox defaultLockType;
    protected TextAdapter defaultSchema;
    protected TextAdapter defaultPackage;
    protected TextAdapter defaultSuperclass;
    protected JCheckBox quoteSQLIdentifiers;
    protected JButton updateDefaultSchema;
    protected JButton updateDefaultPackage;
    protected JButton updateDefaultSuperclass;
    protected JButton updateDefaultLockType;
    protected JCheckBox clientSupport;
    protected JLabel defaultClientPackageLabel;
    protected TextAdapter defaultClientPackage;
    protected TextAdapter defaultClientSuperclass;
    protected JButton updateDefaultClientPackage;
    protected JButton updateDefaultClientSuperclass;

    public DataMapView(ProjectController eventController) {
        this.eventController = eventController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDataMapName(text);
            }
        };
        this.location = new JLabel();
        this.nodeSelector = CayenneWidgetFactory.createUndoableComboBox();
        this.nodeSelector.setRenderer(CellRenderers.listRendererWithIcons());
        this.updateDefaultSchema = new JButton("Update...");
        this.defaultSchema = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDefaultSchema(text);
            }
        };
        this.quoteSQLIdentifiers = new JCheckBox();
        this.updateDefaultPackage = new JButton("Update...");
        this.defaultPackage = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDefaultPackage(text);
            }
        };
        this.updateDefaultSuperclass = new JButton("Update...");
        this.defaultSuperclass = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDefaultSuperclass(text);
            }
        };
        this.updateDefaultLockType = new JButton("Update...");
        this.defaultLockType = new JCheckBox();
        this.clientSupport = new JCheckBox();
        this.updateDefaultClientPackage = new JButton("Update...");
        this.defaultClientPackage = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDefaultClientPackage(text);
            }
        };
        this.updateDefaultClientSuperclass = new JButton("Update...");
        this.defaultClientSuperclass = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataMapView.this.setDefaultClientSuperclass(text);
            }
        };
        FormLayout layout = new FormLayout("right:70dlu, 3dlu, fill:110dlu, 3dlu, fill:100", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("DataMap Configuration");
        builder.append("DataMap Name:", (Component)this.name.getComponent(), 3);
        builder.append("File:", (Component)this.location, 3);
        builder.append("DataNode:", (Component)this.nodeSelector, 3);
        builder.append("Quote SQL Identifiers:", (Component)this.quoteSQLIdentifiers, 3);
        builder.appendSeparator("Entity Defaults");
        builder.append("DB Schema:", (Component)this.defaultSchema.getComponent(), (Component)this.updateDefaultSchema);
        builder.append("Java Package:", (Component)this.defaultPackage.getComponent(), (Component)this.updateDefaultPackage);
        builder.append("Custom Superclass:", (Component)this.defaultSuperclass.getComponent(), (Component)this.updateDefaultSuperclass);
        builder.append("Optimistic Locking:", (Component)this.defaultLockType, (Component)this.updateDefaultLockType);
        builder.appendSeparator("Client Class Defaults");
        builder.append("Allow Client Entities:", (Component)this.clientSupport, (Component)new JPanel());
        this.defaultClientPackageLabel = builder.append("Client Java Package:", (Component)this.defaultClientPackage.getComponent(), (Component)this.updateDefaultClientPackage);
        builder.append("Custom Superclass:", (Component)this.defaultClientSuperclass.getComponent(), (Component)this.updateDefaultClientSuperclass);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.eventController.addDataMapDisplayListener(new DataMapDisplayListener(){

            public void currentDataMapChanged(DataMapDisplayEvent e) {
                DataMap map = e.getDataMap();
                if (map != null) {
                    DataMapView.this.initFromModel(map);
                }
            }
        });
        this.nodeSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.setDataNode();
            }
        });
        this.quoteSQLIdentifiers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.setQuoteSQLIdentifiers(DataMapView.this.quoteSQLIdentifiers.isSelected());
            }
        });
        this.defaultLockType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.setDefaultLockType(DataMapView.this.defaultLockType.isSelected() ? 1 : 0);
            }
        });
        this.clientSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.setClientSupport(DataMapView.this.clientSupport.isSelected());
            }
        });
        this.updateDefaultClientPackage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultClientPackage();
            }
        });
        this.updateDefaultClientSuperclass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultClientSuperclass();
            }
        });
        this.updateDefaultSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultSchema();
            }
        });
        this.updateDefaultPackage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultPackage();
            }
        });
        this.updateDefaultSuperclass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultSuperclass();
            }
        });
        this.updateDefaultLockType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapView.this.updateDefaultLockType();
            }
        });
    }

    private void initFromModel(DataMap map) {
        this.name.setText(map.getName());
        String locationText = map.getLocation();
        this.location.setText(locationText != null ? locationText : "(no file)");
        this.quoteSQLIdentifiers.setSelected(map.isQuotingSQLIdentifiers());
        Object[] nodes = this.eventController.getCurrentDataDomain().getDataNodes().toArray();
        Object[] objects = new Object[nodes.length + 1];
        if (nodes.length > 0) {
            Arrays.sort(nodes, Comparators.getNamedObjectComparator());
            System.arraycopy(nodes, 0, objects, 1, nodes.length);
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(objects);
        for (int i = 0; i < nodes.length; ++i) {
            DataNode node = (DataNode)nodes[i];
            if (!node.getDataMaps().contains(map)) continue;
            model.setSelectedItem(node);
            break;
        }
        this.nodeSelector.setModel(model);
        this.defaultLockType.setSelected(map.getDefaultLockType() != 0);
        this.defaultPackage.setText(map.getDefaultPackage());
        this.defaultSchema.setText(map.getDefaultSchema());
        this.defaultSuperclass.setText(map.getDefaultSuperclass());
        this.clientSupport.setSelected(map.isClientSupported());
        this.defaultClientPackage.setText(map.getDefaultClientPackage());
        this.defaultClientSuperclass.setText(map.getDefaultClientSuperclass());
        this.toggleClientProperties(map.isClientSupported());
    }

    private void toggleClientProperties(boolean enabled) {
        this.defaultClientPackage.getComponent().setEnabled(enabled);
        this.updateDefaultClientPackage.setEnabled(enabled);
        this.defaultClientPackageLabel.setEnabled(enabled);
        this.defaultClientSuperclass.getComponent().setEnabled(enabled);
        this.updateDefaultClientSuperclass.setEnabled(enabled);
    }

    void setDefaultLockType(int lockType) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        int oldType = dataMap.getDefaultLockType();
        if (oldType == lockType) {
            return;
        }
        dataMap.setDefaultLockType(lockType);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setClientSupport(boolean flag) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.isClientSupported() != flag) {
            dataMap.setClientSupported(flag);
            this.toggleClientProperties(flag);
            this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
        }
    }

    void setQuoteSQLIdentifiers(boolean flag) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.isQuotingSQLIdentifiers() != flag) {
            dataMap.setQuotingSQLIdentifiers(flag);
            this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
        }
    }

    void setDefaultPackage(String newDefaultPackage) {
        String oldPackage;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newDefaultPackage != null && newDefaultPackage.trim().length() == 0) {
            newDefaultPackage = null;
        }
        if (Util.nullSafeEquals((Object)newDefaultPackage, (Object)(oldPackage = dataMap.getDefaultPackage()))) {
            return;
        }
        dataMap.setDefaultPackage(newDefaultPackage);
        this.eventController.getDataMapPreferences("").setSuperclassPackage(newDefaultPackage, "auto");
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultClientPackage(String newDefaultPackage) {
        String oldPackage;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newDefaultPackage != null && newDefaultPackage.trim().length() == 0) {
            newDefaultPackage = null;
        }
        if (Util.nullSafeEquals((Object)newDefaultPackage, (Object)(oldPackage = dataMap.getDefaultClientPackage()))) {
            return;
        }
        dataMap.setDefaultClientPackage(newDefaultPackage);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultClientSuperclass(String newSuperclass) {
        String oldSuperclass;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSuperclass != null && newSuperclass.trim().length() == 0) {
            newSuperclass = null;
        }
        if (Util.nullSafeEquals((Object)newSuperclass, (Object)(oldSuperclass = dataMap.getDefaultClientSuperclass()))) {
            return;
        }
        dataMap.setDefaultClientSuperclass(newSuperclass);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultSchema(String newSchema) {
        String oldSchema;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSchema != null && newSchema.trim().length() == 0) {
            newSchema = null;
        }
        if (Util.nullSafeEquals((Object)newSchema, (Object)(oldSchema = dataMap.getDefaultSchema()))) {
            return;
        }
        dataMap.setDefaultSchema(newSchema);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultSuperclass(String newSuperclass) {
        String oldSuperclass;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSuperclass != null && newSuperclass.trim().length() == 0) {
            newSuperclass = null;
        }
        if (Util.nullSafeEquals((Object)newSuperclass, (Object)(oldSuperclass = dataMap.getDefaultSuperclass()))) {
            return;
        }
        dataMap.setDefaultSuperclass(newSuperclass);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDataMapName(String newName) {
        if (newName == null || newName.trim().length() == 0) {
            throw new ValidationException("Enter name for DataMap");
        }
        DataMap map = this.eventController.getCurrentDataMap();
        Configuration config = ((ApplicationProject)Application.getProject()).getConfiguration();
        DataMap matchingMap = null;
        for (DataDomain domain : config.getDomains()) {
            DataMap nextMap = domain.getMap(newName);
            if (nextMap == map || nextMap == null) continue;
            matchingMap = nextMap;
            break;
        }
        if (matchingMap != null) {
            throw new ValidationException("There is another DataMap named '" + newName + "'. Use a different name.");
        }
        String oldName = map.getName();
        if (Util.nullSafeEquals((Object)newName, (Object)oldName)) {
            return;
        }
        DataMapDefaults pref = this.eventController.getDataMapPreferences("");
        DataMapEvent e = new DataMapEvent((Object)this, map, map.getName());
        ProjectUtil.setDataMapName(this.eventController.getCurrentDataDomain(), map, newName);
        pref.rename(newName);
        this.eventController.fireDataMapEvent(e);
    }

    void setDataNode() {
        DataNode node = (DataNode)this.nodeSelector.getSelectedItem();
        DataMap map = this.eventController.getCurrentDataMap();
        if (node != null && node.getDataMaps().contains(map)) {
            return;
        }
        boolean hasChanges = false;
        for (DataNode nextNode : this.eventController.getCurrentDataDomain().getDataNodes()) {
            if (nextNode == node || !nextNode.getDataMaps().contains(map)) continue;
            nextNode.removeDataMap(map.getName());
            this.eventController.fireDataNodeEvent(new DataNodeEvent((Object)this, nextNode));
            hasChanges = true;
        }
        if (node != null) {
            node.addDataMap(map);
            hasChanges = true;
            this.eventController.fireDataNodeEvent(new DataNodeEvent((Object)this, node));
        }
        if (hasChanges) {
            this.eventController.getCurrentDataDomain().reindexNodes();
        }
    }

    void updateDefaultSchema() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getDbEntities().size() > 0 || dataMap.getProcedures().size() > 0) {
            new SchemaUpdateController(this.eventController, dataMap).startup();
        }
    }

    void updateDefaultSuperclass() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new SuperclassUpdateController(this.eventController, dataMap, false).startup();
        }
    }

    void updateDefaultPackage() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0 || dataMap.getEmbeddables().size() > 0) {
            new PackageUpdateController(this.eventController, dataMap, false).startup();
        }
    }

    void updateDefaultClientPackage() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new PackageUpdateController(this.eventController, dataMap, true).startup();
        }
    }

    void updateDefaultClientSuperclass() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new SuperclassUpdateController(this.eventController, dataMap, true).startup();
        }
    }

    void updateDefaultLockType() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new LockingUpdateController(this.eventController, dataMap).startup();
        }
    }
}

