/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.EjbqlQueryPropertiesPanel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class EjbqlQueryMainTab
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected EjbqlQueryPropertiesPanel properties;
    protected TextAdapter qualifier;

    public EjbqlQueryMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                EjbqlQueryMainTab.this.setQueryName(text);
            }
        };
        this.properties = new EjbqlQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("EJBQL Query Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof EJBQLQuery)) {
            this.setVisible(false);
            return;
        }
        EJBQLQuery ejbqlQuery = (EJBQLQuery)query;
        this.name.setText(ejbqlQuery.getName());
        this.properties.initFromModel((Query)ejbqlQuery);
        this.setVisible(true);
    }

    protected EJBQLQuery getQuery() {
        Query query = this.mediator.getCurrentQuery();
        return query instanceof EJBQLQuery ? (EJBQLQuery)query : null;
    }

    void setQueryName(String newName) {
        EJBQLQuery query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals((Object)newName, (Object)query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.");
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQuery(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.");
        }
        QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName());
        ProjectUtil.setQueryName(map, (Query)query, newName);
        this.mediator.fireQueryEvent(e);
    }
}

