/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

public class DeepMergeOperation {
    protected ObjectContext context;
    protected Map<ObjectId, Persistent> seen;

    public DeepMergeOperation(ObjectContext context) {
        this.context = context;
        this.seen = new HashMap<ObjectId, Persistent>();
    }

    public void reset() {
        this.seen.clear();
    }

    public Object merge(Object object, ClassDescriptor descriptor) {
        if (!(object instanceof Persistent)) {
            throw new CayenneRuntimeException("Expected Persistent, got: " + object);
        }
        final Persistent source = (Persistent)object;
        ObjectId id = source.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + source);
        }
        Persistent seenTarget = this.seen.get(id);
        if (seenTarget != null) {
            return seenTarget;
        }
        final Persistent target = this.context.localObject(id, source);
        this.seen.put(id, target);
        descriptor = descriptor.getSubclassDescriptor(source.getClass());
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitToOne(ToOneProperty property) {
                if (!property.isFault(source)) {
                    Object destinationSource = property.readProperty(source);
                    Object destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor()) : null;
                    Object oldTarget = property.isFault(target) ? null : property.readProperty(target);
                    property.writePropertyDirectly(target, oldTarget, destinationTarget);
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                if (!property.isFault(source)) {
                    Cloneable targetValue;
                    Object value = property.readProperty(source);
                    if (property instanceof ToManyMapProperty) {
                        Map map = (Map)value;
                        HashMap targetMap = new HashMap();
                        for (Map.Entry entry : map.entrySet()) {
                            Object destinationSource = entry.getValue();
                            Object destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor()) : null;
                            targetMap.put(entry.getKey(), destinationTarget);
                        }
                        targetValue = targetMap;
                    } else {
                        Collection collection = (Collection)value;
                        ArrayList<Object> targetCollection = new ArrayList<Object>(collection.size());
                        for (Object destinationSource : collection) {
                            Object destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor()) : null;
                            targetCollection.add(destinationTarget);
                        }
                        targetValue = targetCollection;
                    }
                    property.writePropertyDirectly(target, null, targetValue);
                }
                return true;
            }

            public boolean visitAttribute(AttributeProperty property) {
                return true;
            }
        });
        return target;
    }
}

