/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.GraphEvent;

public class EventUtil {
    static final EventSubject[] CHANNEL_SUBJECTS = new EventSubject[]{DataChannel.GRAPH_CHANGED_SUBJECT, DataChannel.GRAPH_FLUSHED_SUBJECT, DataChannel.GRAPH_ROLLEDBACK_SUBJECT};

    public static boolean listenForChannelEvents(DataChannel channel, DataChannelListener listener) {
        EventManager manager = channel.getEventManager();
        if (manager == null) {
            return false;
        }
        EventUtil.listenForSubjects(manager, listener, channel, CHANNEL_SUBJECTS);
        return true;
    }

    public static boolean listenForChannelEvents(EventManager manager, DataChannelListener listener) {
        if (manager == null) {
            return false;
        }
        EventUtil.listenForSubjects(manager, listener, null, CHANNEL_SUBJECTS);
        return true;
    }

    static void listenForSubjects(EventManager manager, DataChannelListener listener, Object sender, EventSubject[] subjects) {
        for (EventSubject subject : subjects) {
            String fqSubject = subject.getSubjectName();
            String method = fqSubject.substring(fqSubject.lastIndexOf(47) + 1);
            manager.addListener(listener, method, GraphEvent.class, subject, sender);
        }
    }

    private EventUtil() {
    }
}

