/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embeddable
implements XMLSerializable,
Serializable {
    protected String className;
    protected SortedMap<String, EmbeddableAttribute> attributes = new TreeMap<String, EmbeddableAttribute>();
    protected DataMap dataMap;

    public Embeddable() {
        this(null);
    }

    public Embeddable(String className) {
        this.className = className;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public Class<?> getJavaClass() {
        String name = this.getClassName();
        try {
            return Util.getJavaClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class " + name + ": " + e.getMessage(), e);
        }
    }

    public EmbeddableAttribute getAttributeForDbPath(String dbPath) {
        for (EmbeddableAttribute attribute : this.attributes.values()) {
            if (!dbPath.equals(attribute.getDbAttributeName())) continue;
            return attribute;
        }
        return null;
    }

    public SortedMap<String, EmbeddableAttribute> getAttributeMap() {
        return Collections.unmodifiableSortedMap(this.attributes);
    }

    public Collection<EmbeddableAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public void addAttribute(EmbeddableAttribute attribute) {
        if (attribute.getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed attribute.");
        }
        Object existingAttribute = this.attributes.get(attribute.getName());
        if (existingAttribute != null) {
            if (existingAttribute == attribute) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override embeddable attribute '" + attribute.getName() + "'");
        }
        this.attributes.put(attribute.getName(), attribute);
        attribute.setEmbeddable(this);
    }

    public EmbeddableAttribute getAttribute(String name) {
        return (EmbeddableAttribute)this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<embeddable");
        if (this.getClassName() != null) {
            encoder.print(" className=\"");
            encoder.print(this.getClassName());
            encoder.print("\"");
        }
        encoder.println(">");
        encoder.indent(1);
        encoder.print(this.attributes);
        encoder.indent(-1);
        encoder.println("</embeddable>");
    }
}

