/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cayenne.access.DataPort;
import org.apache.cayenne.access.DataPortDelegate;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.NamePatternMatcher;
import org.apache.tools.ant.Task;

class AntDataPortDelegate
implements DataPortDelegate {
    protected Task parentTask;
    protected Pattern[] mapFilters;
    protected long timestamp;
    protected DbEntity lastEntity;
    protected NamePatternMatcher namePatternMatcher;

    AntDataPortDelegate() {
        this.mapFilters = new Pattern[0];
    }

    AntDataPortDelegate(Task parentTask, String mapsPattern, String includeEntitiesPattern, String excludeEntitiesPattern) {
        this.parentTask = parentTask;
        this.namePatternMatcher = new NamePatternMatcher(new AntLogger(parentTask), includeEntitiesPattern, excludeEntitiesPattern);
        this.mapFilters = this.namePatternMatcher.createPatterns(mapsPattern);
    }

    protected List filterEntities(List entities) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            DbEntity entity = (DbEntity)it.next();
            if (this.passedDataMapFilter(entity.getDataMap())) continue;
            it.remove();
        }
        this.namePatternMatcher.filter(entities);
        return entities;
    }

    protected boolean passedDataMapFilter(DataMap map) {
        if (this.mapFilters.length == 0) {
            return true;
        }
        if (map == null) {
            return true;
        }
        String mapName = map.getName();
        for (Pattern mapFilter : this.mapFilters) {
            if (!mapFilter.matcher(mapName).find()) continue;
            return true;
        }
        return false;
    }

    public List willPortEntities(DataPort portTool, List entities) {
        return this.filterEntities(entities);
    }

    public Query willPortEntity(DataPort portTool, DbEntity entity, Query query) {
        this.parentTask.log("Porting '" + entity.getName() + "'");
        this.lastEntity = entity;
        this.timestamp = System.currentTimeMillis();
        return query;
    }

    public void didPortEntity(DataPort portTool, DbEntity entity, int rowCount) {
        String timestampLabel = "";
        if (this.lastEntity == entity) {
            timestampLabel = " in " + (System.currentTimeMillis() - this.timestamp) + " ms.";
        }
        String label = rowCount == 1 ? "1 row transferred" : rowCount + " rows transferred";
        this.parentTask.log("Done porting " + entity.getName() + ", " + label + timestampLabel, 3);
    }

    public List willCleanData(DataPort portTool, List entities) {
        return this.filterEntities(entities);
    }

    public Query willCleanData(DataPort portTool, DbEntity entity, Query query) {
        this.parentTask.log("Deleting " + entity.getName(), 3);
        this.lastEntity = entity;
        this.timestamp = System.currentTimeMillis();
        return query;
    }

    public void didCleanData(DataPort portTool, DbEntity entity, int rowCount) {
        String timestampLabel = "";
        if (this.lastEntity == entity) {
            timestampLabel = " in " + (System.currentTimeMillis() - this.timestamp) + " ms.";
        }
        String label = rowCount == 1 ? "1 row deleted" : rowCount + " rows deleted";
        this.parentTask.log("Done deleting " + entity.getName() + ", " + label + timestampLabel, 3);
    }
}

