/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.Map;
import java.util.Set;
import org.objectstyle.ashwood.graph.layout.DefaultLayerPartition;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;
import org.objectstyle.ashwood.graph.layout.RankFunction;
import org.objectstyle.ashwood.graph.layout.TopologicalRankFunction;
import org.objectstyle.ashwood.util.IndexComparator;

public class HierarchyLayout
extends DigraphLayout {
    private RankFunction rankFunction;
    private DefaultLayerPartition layerPartition;
    private int sortIterationCount = 20;
    private IndexComparator layerSortComparator = new IndexComparator();
    private Set[] subgraphPartition;

    public void doLayout() {
        this.rankVertices();
        this.sortVertices();
        this.positionVertices();
        this.positionArcs();
    }

    protected void rankVertices() {
        this.rankFunction = new TopologicalRankFunction(this.digraph);
    }

    protected void sortVertices() {
        this.layerPartition = new DefaultLayerPartition(this.digraph, this.rankFunction, this.vertexShape, this.subgraphPartition);
        this.layerPartition.breadthFirstSort();
        int crossingCount = this.layerPartition.countCrossings();
        Map orderSnapshot = this.layerPartition.makeOrderSnapshot();
        boolean lastIsBest = true;
        for (int i = 0; i < this.sortIterationCount; ++i) {
            if (i % 2 == 0) {
                this.layerPartition.sortDownByMedian();
            } else {
                this.layerPartition.sortUpByMedian();
            }
            int newCrossingCount = this.layerPartition.countCrossings();
            if (newCrossingCount < crossingCount) {
                crossingCount = newCrossingCount;
                orderSnapshot = this.layerPartition.makeOrderSnapshot();
                lastIsBest = true;
                continue;
            }
            if (newCrossingCount <= crossingCount) continue;
            lastIsBest = false;
        }
        if (!lastIsBest) {
            this.layerPartition.restoreOrder(orderSnapshot);
        }
        this.layerPartition.refreshIndices();
    }

    protected void positionVertices() {
        this.layerPartition.setAlternatePendulumTraversals(false);
        this.layerPartition.setHorizontalSpacing(this.horizontalSpacing);
        this.layerPartition.setVerticalSpacing(this.verticalSpacing);
        this.layerPartition.setVerticalAlignment(this.verticalAligment);
        this.layerPartition.setRubberForceThreshold(1.0);
        this.layerPartition.createSubgraphPartition();
        this.layerPartition.positionDummies();
        this.layerPartition.setDummyFixed(true);
        this.layerPartition.balancePendulum(100);
        this.layerPartition.balanceRubberBends(100);
        this.layerPartition.positionLayers();
        this.layerPartition.updateGeometry(this.vertexShape, this.areaBounds);
    }

    protected void positionArcs() {
        this.arcGeometry = this.layerPartition.positionArcs();
    }

    public void setSubgraphPartition(Set[] subgraphPartition) {
        this.subgraphPartition = subgraphPartition;
    }

    public Set[] getSubgraphPartition() {
        return this.subgraphPartition;
    }
}

