/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IndexExtractorFromBitmapExtractorTest
extends AbstractIndexExtractorTest {
    @Override
    protected IndexExtractor createEmptyExtractor() {
        TestingBitMapExtractor testingBitMapExtractor = new TestingBitMapExtractor(new long[0]);
        return IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
    }

    @Override
    protected IndexExtractor createExtractor() {
        TestingBitMapExtractor testingBitMapExtractor = new TestingBitMapExtractor(new long[]{1L, 2L, 3L});
        return IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 3;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{0, 65, 128, 129};
    }

    @Test
    public final void testFromBitMapExtractor() {
        IndexExtractor underTest = this.createExtractor();
        ArrayList lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assertions.assertEquals((int)4, (int)lst.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)lst.get(0)));
        Assertions.assertEquals((Integer)65, (Integer)((Integer)lst.get(1)));
        Assertions.assertEquals((Integer)128, (Integer)((Integer)lst.get(2)));
        Assertions.assertEquals((Integer)129, (Integer)((Integer)lst.get(3)));
        TestingBitMapExtractor bitMapExtractor = new TestingBitMapExtractor(new long[]{-1L});
        underTest = IndexExtractor.fromBitMapExtractor((BitMapExtractor)bitMapExtractor);
        lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assertions.assertEquals((int)64, (int)lst.size());
        for (int i = 0; i < 64; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)lst.get(i)));
        }
    }

    private static final class TestingBitMapExtractor
    implements BitMapExtractor {
        long[] values;

        TestingBitMapExtractor(long[] values) {
            this.values = values;
        }

        public boolean processBitMaps(LongPredicate consumer) {
            for (long l : this.values) {
                if (consumer.test(l)) continue;
                return false;
            }
            return true;
        }
    }
}

