/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedCollectionBuilderTest {
    private void checkPredicatedCollection1(Collection<String> collection) {
        Assertions.assertEquals((int)1, (int)collection.size());
        collection.add("test2");
        Assertions.assertEquals((int)2, (int)collection.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> collection.add(null), (String)"Expecting IllegalArgumentException for failing predicate!");
    }

    private void checkPredicatedCollection2(Collection<Integer> collection) {
        Assertions.assertEquals((int)2, (int)collection.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> collection.add(4), (String)"Expecting IllegalArgumentException for failing predicate!");
        Assertions.assertEquals((int)2, (int)collection.size());
        collection.add(5);
        Assertions.assertEquals((int)3, (int)collection.size());
    }

    @Test
    public void testAddAllPass() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.addAll(Arrays.asList("test1", null, "test2"));
        Assertions.assertEquals((int)builder.createPredicatedList().size(), (int)2);
    }

    @Test
    public void testAddFail() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)null);
        Assertions.assertTrue((boolean)builder.createPredicatedList().isEmpty());
        Assertions.assertEquals((int)1, (int)builder.rejectedElements().size());
    }

    @Test
    public void testAddPass() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)"test");
        Assertions.assertEquals((int)builder.createPredicatedList().size(), (int)1);
    }

    @Test
    public void testCreatePredicatedCollectionWithNotNullPredicate() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)"test1");
        builder.add((Object)null);
        List predicatedList = builder.createPredicatedList();
        this.checkPredicatedCollection1(predicatedList);
        Set predicatedSet = builder.createPredicatedSet();
        this.checkPredicatedCollection1(predicatedSet);
        Bag predicatedBag = builder.createPredicatedBag();
        this.checkPredicatedCollection1((Collection<String>)predicatedBag);
        Queue predicatedQueue = builder.createPredicatedQueue();
        this.checkPredicatedCollection1(predicatedQueue);
    }

    @Test
    public void testCreatePredicatedCollectionWithPredicate() {
        OddPredicate p = new OddPredicate();
        PredicatedCollection.Builder builder = PredicatedCollection.builder((Predicate)p);
        builder.add((Object)1);
        builder.add((Object)2);
        builder.add((Object)3);
        List predicatedList = builder.createPredicatedList();
        this.checkPredicatedCollection2(predicatedList);
        Set predicatedSet = builder.createPredicatedSet();
        this.checkPredicatedCollection2(predicatedSet);
        Bag predicatedBag = builder.createPredicatedBag();
        this.checkPredicatedCollection2((Collection<Integer>)predicatedBag);
        Queue predicatedQueue = builder.createPredicatedQueue();
        this.checkPredicatedCollection2(predicatedQueue);
    }

    private static final class OddPredicate
    implements Predicate<Integer> {
        private OddPredicate() {
        }

        public boolean evaluate(Integer value) {
            return value % 2 == 1;
        }
    }
}

