/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.collections4.map.UnmodifiableOrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableOrderedMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public OrderedMap<K, V> makeFullMap() {
        ListOrderedMap m = ListOrderedMap.listOrderedMap(new HashMap());
        this.addSampleMappings(m);
        return UnmodifiableOrderedMap.unmodifiableOrderedMap((OrderedMap)m);
    }

    @Override
    public OrderedMap<K, V> makeObject() {
        return UnmodifiableOrderedMap.unmodifiableOrderedMap((OrderedMap)ListOrderedMap.listOrderedMap(new HashMap()));
    }

    @Test
    public void testDecorateFactory() {
        OrderedMap<K, V> map = this.makeFullMap();
        Assertions.assertSame(map, (Object)UnmodifiableOrderedMap.unmodifiableOrderedMap(map));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableOrderedMap.unmodifiableOrderedMap(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }
}

