/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.Locale;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationNodePointer
extends AbstractXPathTest {
    NodePointer pointer;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.pointer = new ConfigurationNodePointer(this.root, Locale.getDefault());
    }

    @Test
    public void testCompareChildNodePointersChildren() {
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, this.root.getChild(1));
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, this.root.getChild(3));
        Assert.assertEquals((String)"Incorrect order", (long)-1L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Incorrect symmetric order", (long)1L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testCompareChildNodePointersAttributes() {
        this.root.addAttribute((ConfigurationNode)new DefaultConfigurationNode("attr1", (Object)"test1"));
        this.root.addAttribute((ConfigurationNode)new DefaultConfigurationNode("attr2", (Object)"test2"));
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, this.root.getAttribute(0));
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, this.root.getAttribute(1));
        Assert.assertEquals((String)"Incorrect order", (long)-1L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Incorrect symmetric order", (long)1L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testCompareChildNodePointersChildAndAttribute() {
        this.root.addAttribute((ConfigurationNode)new DefaultConfigurationNode("attr1", (Object)"test1"));
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, this.root.getChild(2));
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, this.root.getAttribute(0));
        Assert.assertEquals((String)"Incorrect order for attributes", (long)1L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Incorrect symmetric order for attributes", (long)-1L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testCompareChildNodePointersInvalidChildren() {
        ConfigurationNode node = this.root.getChild(1);
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, node.getChild(1));
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, node.getChild(3));
        Assert.assertEquals((String)"Non child nodes could be sorted", (long)0L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Non child nodes could be sorted symmetrically", (long)0L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testIsAttribute() {
        DefaultConfigurationNode node = new DefaultConfigurationNode("test", (Object)"testval");
        ConfigurationNodePointer p = new ConfigurationNodePointer(this.pointer, (ConfigurationNode)node);
        Assert.assertFalse((String)"Node is an attribute", (boolean)p.isAttribute());
        node.setAttribute(true);
        Assert.assertTrue((String)"Node is no attribute", (boolean)p.isAttribute());
    }

    @Test
    public void testIsLeave() {
        Assert.assertFalse((String)"Root node is leaf", (boolean)this.pointer.isLeaf());
        NodePointer p = this.pointer;
        while (!p.isLeaf()) {
            ConfigurationNode node = (ConfigurationNode)p.getNode();
            Assert.assertTrue((String)"Node has no children", (node.getChildrenCount() > 0 ? 1 : 0) != 0);
            p = new ConfigurationNodePointer(p, node.getChild(0));
        }
        Assert.assertTrue((String)"Node has children", (((ConfigurationNode)p.getNode()).getChildrenCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIterators() {
        this.checkIterators(this.pointer);
    }

    private void checkIterators(NodePointer p) {
        ConfigurationNode node = (ConfigurationNode)p.getNode();
        NodeIterator it = p.childIterator(null, false, null);
        Assert.assertEquals((String)"Iterator count differs from children count", (long)node.getChildrenCount(), (long)this.iteratorSize(it));
        int index = 1;
        while (it.setPosition(index)) {
            NodePointer pchild = it.getNodePointer();
            Assert.assertEquals((String)"Wrong child", (Object)node.getChild(index - 1), (Object)pchild.getNode());
            this.checkIterators(pchild);
            ++index;
        }
        it = p.attributeIterator(new QName(null, "*"));
        Assert.assertEquals((String)"Iterator count differs from attribute count", (long)node.getAttributeCount(), (long)this.iteratorSize(it));
        index = 1;
        while (it.setPosition(index)) {
            NodePointer pattr = it.getNodePointer();
            Assert.assertTrue((String)"Node pointer is no attribute", (boolean)pattr.isAttribute());
            Assert.assertEquals((String)"Wrong attribute", (Object)node.getAttribute(index - 1), (Object)pattr.getNode());
            this.checkIterators(pattr);
            ++index;
        }
    }
}

