/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractConfigurationBasicFeatures {
    private static final String KEY_PREFIX = "key";
    private static final int PROP_COUNT = 12;

    @Test
    public void testClearIteratorNoRemove() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new BaseConfiguration()){

            @Override
            public Iterator<String> getKeys() {
                ArrayList keyCol = new ArrayList();
                CollectionUtils.addAll(keyCol, (Iterator)this.getUnderlyingConfiguration().getKeys());
                String[] keys = keyCol.toArray(new String[keyCol.size()]);
                return Arrays.asList(keys).iterator();
            }
        };
        for (int i = 0; i < 20; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        config.clear();
        Assert.assertTrue((String)"Configuration not empty", (boolean)config.isEmpty());
    }

    @Test
    public void testInterpolateEscape() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.addProperty("mypath", "$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar\\,$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar");
        Assert.assertEquals((String)"Wrong interpolated value", (Object)"${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar,${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar", (Object)config.getString("mypath"));
    }

    @Test
    public void testAddPropertyList() {
        this.checkAddListProperty(new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration()));
    }

    @Test
    public void testAddPropertyListNoDelimiterParsing() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setDelimiterParsingDisabled(true);
        this.checkAddListProperty(config);
    }

    private void checkAddListProperty(AbstractConfiguration config) {
        config.addProperty("test", (Object)"value1");
        Object[] lstValues1 = new Object[]{"value2", "value3"};
        Object[] lstValues2 = new Object[]{"value4", "value5", "value6"};
        config.addProperty("test", (Object)lstValues1);
        config.addProperty("test", Arrays.asList(lstValues2));
        List lst = config.getList("test");
        Assert.assertEquals((String)"Wrong number of list elements", (long)6L, (long)lst.size());
        for (int i = 0; i < lst.size(); ++i) {
            Assert.assertEquals((String)("Wrong list element at " + i), (Object)("value" + (i + 1)), lst.get(i));
        }
    }

    @Test
    public void testCopy() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.copy(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                Assert.assertEquals((String)("Value not replaced: " + key), (Object)srcConfig.getProperty(key), (Object)config.getProperty(key));
                continue;
            }
            Assert.assertEquals((String)("Value modified: " + key), (Object)("value" + i), (Object)config.getProperty(key));
        }
    }

    @Test
    public void testCopyWithLists() {
        Configuration srcConfig = this.setUpSourceConfig();
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(srcConfig);
        this.checkListProperties((Configuration)config);
    }

    @Test
    public void testCopyEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addConfigurationListener((ConfigurationListener)l);
        config.copy(srcConfig);
        this.checkCopyEvents(l, srcConfig, 3);
    }

    @Test
    public void testCopyNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(null);
        ConfigurationAssert.assertEquals((Configuration)this.setUpDestConfig(), (Configuration)config);
    }

    @Test
    public void testAppend() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.append(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                List values = config.getList(key);
                Assert.assertEquals((String)("Value not added: " + key), (long)2L, (long)values.size());
                Assert.assertEquals((String)("Wrong value 1 for " + key), (Object)("value" + i), values.get(0));
                Assert.assertEquals((String)("Wrong value 2 for " + key), (Object)("src" + i), values.get(1));
                continue;
            }
            Assert.assertEquals((String)("Value modified: " + key), (Object)("value" + i), (Object)config.getProperty(key));
        }
    }

    @Test
    public void testAppendWithLists() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(this.setUpSourceConfig());
        this.checkListProperties((Configuration)config);
    }

    @Test
    public void testAppendEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addConfigurationListener((ConfigurationListener)l);
        config.append(srcConfig);
        this.checkCopyEvents(l, srcConfig, 1);
    }

    @Test
    public void testAppendNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(null);
        ConfigurationAssert.assertEquals((Configuration)this.setUpDestConfig(), (Configuration)config);
    }

    @Test
    public void testInterpolateEnvironmentVariables() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        HashMap<String, String> env = new HashMap<String, String>();
        Iterator it = envConfig.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String propKey = "envtest." + key;
            env.put(propKey, envConfig.getString(key));
            config.addProperty(propKey, "${env:" + key + "}");
        }
        Assert.assertFalse((String)"No environment properties", (boolean)env.isEmpty());
        for (Map.Entry e : env.entrySet()) {
            Assert.assertEquals((String)("Wrong value for " + (String)e.getKey()), e.getValue(), (Object)config.getString((String)e.getKey()));
        }
    }

    @Test
    public void testGetListNonString() {
        this.checkGetListScalar(42);
        this.checkGetListScalar(42L);
        this.checkGetListScalar((short)42);
        this.checkGetListScalar((byte)42);
        this.checkGetListScalar(Float.valueOf(42.0f));
        this.checkGetListScalar(42.0);
        this.checkGetListScalar(Boolean.TRUE);
    }

    @Test
    public void testGetStringArrayNonString() {
        this.checkGetStringArrayScalar(42);
        this.checkGetStringArrayScalar(42L);
        this.checkGetStringArrayScalar((short)42);
        this.checkGetStringArrayScalar((byte)42);
        this.checkGetStringArrayScalar(Float.valueOf(42.0f));
        this.checkGetStringArrayScalar(42.0);
        this.checkGetStringArrayScalar(Boolean.TRUE);
    }

    private void checkGetListScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        List lst = config.getList(KEY_PREFIX);
        Assert.assertEquals((String)"Wrong number of values", (long)1L, (long)lst.size());
        Assert.assertEquals((String)"Wrong value", (Object)value.toString(), lst.get(0));
    }

    private void checkGetStringArrayScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        String[] array = config.getStringArray(KEY_PREFIX);
        Assert.assertEquals((String)"Weong number of elements", (long)1L, (long)array.length);
        Assert.assertEquals((String)"Wrong value", (Object)value.toString(), (Object)array[0]);
    }

    @Test
    public void testNestedVariableInterpolation() {
        BaseConfiguration config = new BaseConfiguration();
        config.getSubstitutor().setEnableSubstitutionInVariables(true);
        config.addProperty("java.version", (Object)"1.4");
        config.addProperty("jre-1.4", (Object)"C:\\java\\1.4");
        config.addProperty("jre.path", (Object)"${jre-${java.version}}");
        Assert.assertEquals((String)"Wrong path", (Object)"C:\\java\\1.4", (Object)config.getString("jre.path"));
    }

    private Configuration setUpSourceConfig() {
        BaseConfiguration config = new BaseConfiguration();
        for (int i = 1; i < 12; i += 2) {
            config.addProperty(KEY_PREFIX + i, (Object)("src" + i));
        }
        config.addProperty("list1", (Object)"1,2,3");
        config.addProperty("list2", (Object)"3\\,1415,9\\,81");
        return config;
    }

    private AbstractConfiguration setUpDestConfig() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        return config;
    }

    private void checkListProperties(Configuration config) {
        List values = config.getList("list1");
        Assert.assertEquals((String)"Wrong number of elements in list 1", (long)3L, (long)values.size());
        values = config.getList("list2");
        Assert.assertEquals((String)"Wrong number of elements in list 2", (long)2L, (long)values.size());
        Assert.assertEquals((String)"Wrong value 1", (Object)"3,1415", values.get(0));
        Assert.assertEquals((String)"Wrong value 2", (Object)"9,81", values.get(1));
    }

    private void checkCopyEvents(CollectingConfigurationListener l, Configuration src, int eventType) {
        HashMap<String, ConfigurationEvent> events = new HashMap<String, ConfigurationEvent>();
        for (ConfigurationEvent e : l.events) {
            Assert.assertEquals((String)"Wrong event type", (long)eventType, (long)e.getType());
            Assert.assertTrue((String)("Unknown property: " + e.getPropertyName()), (boolean)src.containsKey(e.getPropertyName()));
            Assert.assertEquals((String)("Wrong property value for " + e.getPropertyName()), (Object)e.getPropertyValue(), (Object)src.getProperty(e.getPropertyName()));
            if (!e.isBeforeUpdate()) {
                Assert.assertTrue((String)"After event without before event", (boolean)events.containsKey(e.getPropertyName()));
                continue;
            }
            events.put(e.getPropertyName(), e);
        }
        Iterator it = src.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("No event received for key " + key), (boolean)events.containsKey(key));
        }
    }

    static class CollectingConfigurationListener
    implements ConfigurationListener {
        List<ConfigurationEvent> events = new ArrayList<ConfigurationEvent>();

        CollectingConfigurationListener() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            this.events.add(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestConfigurationImpl
    extends AbstractConfiguration {
        private AbstractConfiguration config;

        public AbstractConfiguration getUnderlyingConfiguration() {
            return this.config;
        }

        public TestConfigurationImpl(AbstractConfiguration wrappedConfig) {
            this.config = wrappedConfig;
        }

        protected void addPropertyDirect(String key, Object value) {
            this.config.addPropertyDirect(key, value);
        }

        public boolean containsKey(String key) {
            return this.config.containsKey(key);
        }

        public Iterator<String> getKeys() {
            return this.config.getKeys();
        }

        public Object getProperty(String key) {
            return this.config.getProperty(key);
        }

        public boolean isEmpty() {
            return this.config.isEmpty();
        }

        protected void clearPropertyDirect(String key) {
            this.config.clearPropertyDirect(key);
        }
    }
}

