/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSubsetConfiguration848 {
    @Test
    public void testSubsetConfigurationWithIndexAndDelimiter() throws ConfigurationException, IOException {
        JSONConfiguration jsonConfiguration = new JSONConfiguration();
        try (FileReader in = new FileReader(ConfigurationAssert.getTestFile("test-configuration-848.json").getAbsolutePath());){
            jsonConfiguration.read((Reader)in);
        }
        ArrayList<JSONConfiguration> list = new ArrayList<JSONConfiguration>();
        list.add(jsonConfiguration);
        list.add(jsonConfiguration);
        CompositeConfiguration composite = new CompositeConfiguration(list);
        Configuration subset = composite.subset("books(0).details");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((int)2, (int)subset.size());
        Assertions.assertEquals((Object)"No Longer Human", (Object)subset.getString("title"));
        subset = new SubsetConfiguration((Configuration)jsonConfiguration, "books(0).details", ".");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((int)2, (int)subset.size());
        Assertions.assertEquals((Object)"No Longer Human", (Object)subset.getString("title"));
        subset = new SubsetConfiguration((Configuration)jsonConfiguration, "books(1)@details", "@");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((int)2, (int)subset.size());
    }

    @Test
    public void testSubsetWithJSONConfiguration() throws ConfigurationException, IOException {
        JSONConfiguration jsonConfiguration = new JSONConfiguration();
        try (FileReader in = new FileReader(ConfigurationAssert.getTestFile("test-configuration-848.json").getAbsolutePath());){
            jsonConfiguration.read((Reader)in);
        }
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)jsonConfiguration, "capitals(0)", ".");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((int)2, (int)subset.size());
        Assertions.assertEquals((Object)"USA", (Object)subset.getString("country"));
    }
}

