/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.HierarchicalBuilderParametersImpl;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHierarchicalBuilderParametersImpl {
    private HierarchicalBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new HierarchicalBuilderParametersImpl();
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        BeanHelper.setProperty((Object)this.params, (String)"expressionEngine", (Object)engine);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Map map = this.params.getParameters();
        Assertions.assertSame((Object)engine, map.get("expressionEngine"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testInheritFrom() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        HierarchicalBuilderParametersImpl params = new HierarchicalBuilderParametersImpl();
        params.setExpressionEngine(engine);
        params.setThrowExceptionOnMissing(true);
        HierarchicalBuilderParametersImpl params2 = new HierarchicalBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)engine, parameters.get("expressionEngine"));
    }

    @Test
    public void testSetExpressionEngine() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setExpressionEngine(engine));
        Assertions.assertSame((Object)engine, this.params.getParameters().get("expressionEngine"));
    }
}

