/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.io.File;
import java.lang.annotation.ElementType;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.MyNumber;
import org.apache.commons.configuration2.convert.PropertyConverter;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestPropertyConverter {
    private static final Class<ElementType> ENUM_CLASS = ElementType.class;

    @Test
    public void testToBigDecimalDoubleConstructor() {
        double d = 0.1;
        Assertions.assertEquals((Object)BigDecimal.valueOf(0.1), (Object)PropertyConverter.toBigDecimal((Object)0.1));
    }

    @Test
    @Disabled
    public void testToBigDecimalStringConstructor() {
        double d = 0.1;
        Assertions.assertEquals((Object)new BigDecimal(Double.toString(0.1)), (Object)PropertyConverter.toBigDecimal((Object)0.1));
    }

    @Test
    public void testToCharFailed() {
        DefaultConversionHandler conversionHandler = new DefaultConversionHandler();
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.to(Character.TYPE, (Object)"FF", (DefaultConversionHandler)conversionHandler));
    }

    @Test
    public void testToCharSuccess() {
        Assertions.assertEquals((Object)Character.valueOf('t'), (Object)PropertyConverter.to(Character.class, (Object)"t", (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test
    public void testToCharViaToString() {
        Object value = new Object(){

            public String toString() {
                return "X";
            }
        };
        Assertions.assertEquals((Object)Character.valueOf('X'), (Object)PropertyConverter.to(Character.TYPE, (Object)value, (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test
    public void testToCustomNumber() {
        Assertions.assertEquals((Object)new MyNumber(1L), (Object)PropertyConverter.to(MyNumber.class, (Object)"1", null));
        Assertions.assertEquals((Object)new MyNumber(2L), (Object)PropertyConverter.to(MyNumber.class, (Object)new MyNumber(2L), null));
        Assertions.assertEquals((Object)new MyNumber(0L), (Object)PropertyConverter.to(MyNumber.class, null, null));
    }

    @Test
    public void testToEnumFromEnum() {
        Assertions.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)((Object)ElementType.METHOD), ENUM_CLASS));
    }

    @Test
    public void testToEnumFromInvalidNumber() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toEnum((Object)-1, ENUM_CLASS));
    }

    @Test
    public void testToEnumFromInvalidString() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toEnum((Object)"FOO", ENUM_CLASS));
    }

    @Test
    public void testToEnumFromNumber() {
        Assertions.assertEquals((Object)PropertyConverter.toEnum((Object)ElementType.METHOD.ordinal(), ENUM_CLASS), (Object)((Object)ElementType.METHOD));
    }

    @Test
    public void testToEnumFromString() {
        Assertions.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)"METHOD", ENUM_CLASS));
    }

    @Test
    public void testToFileDirect() {
        File f = new File("dir", "file");
        Assertions.assertSame((Object)f, (Object)PropertyConverter.toFile((Object)f));
    }

    @Test
    public void testToFileFromPath() {
        Path p = Paths.get("dir", "file");
        Assertions.assertEquals((Object)new File("dir", "file"), (Object)PropertyConverter.toFile((Object)p));
    }

    @Test
    public void testToFileFromString() {
        Assertions.assertEquals((Object)new File("dir", "file"), (Object)PropertyConverter.toFile((Object)"dir/file"));
    }

    @Test
    public void testToNoConversionNeeded() {
        String value = "testValue";
        Assertions.assertEquals((Object)"testValue", (Object)PropertyConverter.to(String.class, (Object)"testValue", (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test
    public void testToNumberDirect() {
        Integer i = 42;
        Assertions.assertSame((Object)i, (Object)PropertyConverter.toNumber((Object)i, Integer.class));
        BigDecimal d = new BigDecimal("3.1415");
        Assertions.assertSame((Object)d, (Object)PropertyConverter.toNumber((Object)d, Integer.class));
    }

    @Test
    public void testToNumberFromBinaryString() {
        Number n = PropertyConverter.toNumber((Object)"0b1111", Integer.class);
        Assertions.assertEquals((int)15, (int)n.intValue());
    }

    @Test
    public void testToNumberFromHexString() {
        Number n = PropertyConverter.toNumber((Object)"0x10", Integer.class);
        Assertions.assertEquals((int)16, (int)n.intValue());
    }

    @Test
    public void testToNumberFromInvalidBinaryString() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toNumber((Object)"0bNotABinValue", Integer.class));
    }

    @Test
    public void testToNumberFromInvalidHexString() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toNumber((Object)"0xNotAHexValue", Integer.class));
    }

    @Test
    public void testToNumberFromInvalidString() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toNumber((Object)"Not a number", Byte.class));
    }

    @Test
    public void testToNumberFromString() {
        Assertions.assertEquals((Object)42, (Object)PropertyConverter.toNumber((Object)"42", Integer.class));
        Assertions.assertEquals((Object)10, (Object)PropertyConverter.toNumber((Object)new StringBuffer("10"), Short.class));
    }

    @Test
    public void testToNumberWithInvalidClass() {
        Assertions.assertThrows(ConversionException.class, () -> PropertyConverter.toNumber((Object)"42", Object.class));
    }

    @Test
    public void testToPathDirect() {
        Path p = Paths.get("dir", "file");
        Assertions.assertSame((Object)p, (Object)PropertyConverter.toPath((Object)p));
    }

    @Test
    public void testToPathFromFile() {
        File f = new File("dir", "file");
        Assertions.assertEquals((Object)Paths.get("dir", "file"), (Object)PropertyConverter.toPath((Object)f));
    }

    @Test
    public void testToPathFromString() {
        Assertions.assertEquals((Object)Paths.get("dir", "file"), (Object)PropertyConverter.toPath((Object)"dir/file"));
    }

    @Test
    public void testToPatternDirect() {
        Pattern p = Pattern.compile(".+");
        Assertions.assertSame((Object)p, (Object)PropertyConverter.toPattern((Object)p));
    }

    @Test
    public void testToPatternFromString() {
        Pattern p = Pattern.compile(".+");
        Assertions.assertEquals((Object)p.pattern(), (Object)PropertyConverter.toPattern((Object)".+").pattern());
    }

    @Test
    public void testToStringConversion() {
        Integer src = 42;
        Object result = PropertyConverter.to(String.class, (Object)src, (DefaultConversionHandler)new DefaultConversionHandler());
        Assertions.assertEquals((Object)"42", (Object)result);
    }
}

