/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.crypto.jna.OpenSslJna;
import org.apache.commons.crypto.jna.OpenSslNativeJna;
import org.apache.commons.crypto.random.CryptoRandom;

final class OpenSslJnaCryptoRandom
implements CryptoRandom {
    private static final int ENGINE_METHOD_RAND = 8;
    private final boolean rdrandEnabled;
    private final transient PointerByReference rdrandEngine;

    public OpenSslJnaCryptoRandom(Properties props) throws GeneralSecurityException {
        if (!OpenSslJna.isEnabled()) {
            throw new GeneralSecurityException("Could not enable JNA access", OpenSslJna.initialisationError());
        }
        boolean rdrandLoaded = false;
        try {
            int rc2;
            int rc;
            OpenSslNativeJna.ENGINE_load_rdrand();
            this.rdrandEngine = OpenSslNativeJna.ENGINE_by_id("rdrand");
            if (this.rdrandEngine != null && (rc = OpenSslNativeJna.ENGINE_init(this.rdrandEngine)) != 0 && (rc2 = OpenSslNativeJna.ENGINE_set_default(this.rdrandEngine, 8)) != 0) {
                rdrandLoaded = true;
            }
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException();
        }
        this.rdrandEnabled = rdrandLoaded;
        if (!rdrandLoaded) {
            this.closeRdrandEngine(false);
        }
    }

    @Override
    public void close() {
        this.closeRdrandEngine(true);
        OpenSslNativeJna.ENGINE_cleanup();
    }

    private void closeRdrandEngine(boolean closing) {
        if (this.rdrandEngine != null) {
            this.throwOnError(OpenSslNativeJna.ENGINE_finish(this.rdrandEngine), closing);
            this.throwOnError(OpenSslNativeJna.ENGINE_free(this.rdrandEngine), closing);
        }
    }

    public boolean isRdrandEnabled() {
        return this.rdrandEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextBytes(byte[] bytes) {
        Class<OpenSslJnaCryptoRandom> clazz = OpenSslJnaCryptoRandom.class;
        synchronized (OpenSslJnaCryptoRandom.class) {
            if (this.rdrandEnabled && OpenSslNativeJna.RAND_get_rand_method().equals((Object)OpenSslNativeJna.RAND_SSLeay())) {
                this.close();
                throw new IllegalStateException("rdrand should be used but default is detected");
            }
            int byteLength = bytes.length;
            ByteBuffer buf = ByteBuffer.allocateDirect(byteLength);
            this.throwOnError(OpenSslNativeJna.RAND_bytes(buf, byteLength), false);
            buf.rewind();
            buf.get(bytes, 0, byteLength);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void throwOnError(int retVal, boolean closing) {
        if (retVal != 1) {
            NativeLong err = OpenSslNativeJna.ERR_peek_error();
            String errdesc = OpenSslNativeJna.ERR_error_string(err, null);
            if (!closing) {
                this.close();
            }
            throw new IllegalStateException("return code " + retVal + " from OpenSSL. Err code is " + err + ": " + errdesc);
        }
    }
}

