/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.input.ChannelInput;
import org.apache.commons.crypto.stream.input.Input;
import org.apache.commons.crypto.stream.input.StreamInput;
import org.apache.commons.crypto.utils.Utils;

public class CryptoInputStream
extends InputStream
implements ReadableByteChannel {
    public static final String STREAM_BUFFER_SIZE_KEY = "commons.crypto.stream.buffer.size";
    private static final int STREAM_BUFFER_SIZE_DEFAULT = 8192;
    private static final int MIN_BUFFER_SIZE = 512;
    public static final int EOS = -1;
    private final byte[] oneByteBuf = new byte[1];
    final CryptoCipher cipher;
    private final int bufferSize;
    final Key key;
    private final AlgorithmParameterSpec params;
    private boolean closed;
    private boolean finalDone;
    Input input;
    ByteBuffer inBuffer;
    ByteBuffer outBuffer;

    static int checkBufferSize(CryptoCipher cipher, int bufferSize) {
        Utils.checkArgument(bufferSize >= 512, "Minimum value of buffer size is 512.");
        return bufferSize - bufferSize % cipher.getBlockSize();
    }

    static void checkStreamCipher(CryptoCipher cipher) throws IOException {
        if (!cipher.getAlgorithm().equals("AES/CTR/NoPadding")) {
            throw new IOException("AES/CTR/NoPadding is required");
        }
    }

    static void freeDirectBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            try {
                String SUN_CLASS = "sun.nio.ch.DirectBuffer";
                Class<?>[] interfaces = buffer.getClass().getInterfaces();
                Object[] EMPTY_OBJECT_ARRAY = new Object[]{};
                Class<?>[] classArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> clazz = classArray[n2];
                    if (clazz.getName().equals("sun.nio.ch.DirectBuffer")) {
                        Method getCleaner = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
                        Object cleaner = getCleaner.invoke((Object)buffer, EMPTY_OBJECT_ARRAY);
                        Method cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                        cleanMethod.invoke(cleaner, EMPTY_OBJECT_ARRAY);
                        return;
                    }
                    ++n2;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static int getBufferSize(Properties props) {
        String bufferSizeStr = props.getProperty(STREAM_BUFFER_SIZE_KEY, "");
        return bufferSizeStr.isEmpty() ? 8192 : Integer.parseInt(bufferSizeStr);
    }

    protected CryptoInputStream(Input input, CryptoCipher cipher, int bufferSize, Key key, AlgorithmParameterSpec params) throws IOException {
        this.input = input;
        this.cipher = cipher;
        this.bufferSize = CryptoInputStream.checkBufferSize(cipher, bufferSize);
        this.key = key;
        this.params = params;
        if (!(params instanceof IvParameterSpec)) {
            throw new IOException("Illegal parameters");
        }
        this.inBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.bufferSize + cipher.getBlockSize());
        this.outBuffer.limit(0);
        this.initCipher();
    }

    protected CryptoInputStream(InputStream inputStream, CryptoCipher cipher, int bufferSize, Key key, AlgorithmParameterSpec params) throws IOException {
        this(new StreamInput(inputStream, bufferSize), cipher, bufferSize, key, params);
    }

    protected CryptoInputStream(ReadableByteChannel channel, CryptoCipher cipher, int bufferSize, Key key, AlgorithmParameterSpec params) throws IOException {
        this(new ChannelInput(channel), cipher, bufferSize, key, params);
    }

    public CryptoInputStream(String transformation, Properties properties, InputStream inputStream, Key key, AlgorithmParameterSpec params) throws IOException {
        this(inputStream, Utils.getCipherInstance(transformation, properties), CryptoInputStream.getBufferSize(properties), key, params);
    }

    public CryptoInputStream(String transformation, Properties properties, ReadableByteChannel channel, Key key, AlgorithmParameterSpec params) throws IOException {
        this(channel, Utils.getCipherInstance(transformation, properties), CryptoInputStream.getBufferSize(properties), key, params);
    }

    @Override
    public int available() throws IOException {
        this.checkStream();
        return this.input.available() + this.outBuffer.remaining();
    }

    protected void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.input.close();
        this.freeBuffers();
        this.cipher.close();
        super.close();
        this.closed = true;
    }

    protected void decrypt() throws IOException {
        this.inBuffer.flip();
        this.outBuffer.clear();
        try {
            this.cipher.update(this.inBuffer, this.outBuffer);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        this.inBuffer.clear();
        this.outBuffer.flip();
    }

    protected void decryptFinal() throws IOException {
        this.inBuffer.flip();
        this.outBuffer.clear();
        try {
            this.cipher.doFinal(this.inBuffer, this.outBuffer);
            this.finalDone = true;
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IOException(e);
        }
        this.inBuffer.clear();
        this.outBuffer.flip();
    }

    protected int decryptMore() throws IOException {
        if (this.finalDone) {
            return -1;
        }
        int n = this.input.read(this.inBuffer);
        if (n < 0) {
            this.decryptFinal();
            int remaining = this.outBuffer.remaining();
            if (remaining > 0) {
                return remaining;
            }
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        this.decrypt();
        return this.outBuffer.remaining();
    }

    protected void freeBuffers() {
        CryptoInputStream.freeDirectBuffer(this.inBuffer);
        CryptoInputStream.freeDirectBuffer(this.outBuffer);
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected CryptoCipher getCipher() {
        return this.cipher;
    }

    protected Input getInput() {
        return this.input;
    }

    protected Key getKey() {
        return this.key;
    }

    protected AlgorithmParameterSpec getParams() {
        return this.params;
    }

    protected void initCipher() throws IOException {
        try {
            this.cipher.init(2, this.key, this.params);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n;
        while ((n = this.read(this.oneByteBuf, 0, 1)) == 0) {
        }
        return n == -1 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] array, int off, int len) throws IOException {
        this.checkStream();
        Objects.requireNonNull(array, "array");
        if (off < 0 || len < 0 || len > array.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int remaining = this.outBuffer.remaining();
        if (remaining > 0) {
            int n = Math.min(len, remaining);
            this.outBuffer.get(array, off, n);
            return n;
        }
        int nd = 0;
        while (nd == 0) {
            nd = this.decryptMore();
        }
        if (nd < 0) {
            return nd;
        }
        int n = Math.min(len, this.outBuffer.remaining());
        this.outBuffer.get(array, off, n);
        return n;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkStream();
        int remaining = this.outBuffer.remaining();
        if (remaining <= 0) {
            int nd = 0;
            while (nd == 0) {
                nd = this.decryptMore();
            }
            if (nd < 0) {
                return -1;
            }
        }
        remaining = this.outBuffer.remaining();
        int toRead = dst.remaining();
        if (toRead <= remaining) {
            int limit = this.outBuffer.limit();
            this.outBuffer.limit(this.outBuffer.position() + toRead);
            dst.put(this.outBuffer);
            this.outBuffer.limit(limit);
            return toRead;
        }
        dst.put(this.outBuffer);
        return remaining;
    }

    @Override
    public long skip(long n) throws IOException {
        Utils.checkArgument(n >= 0L, "Negative skip length.");
        this.checkStream();
        if (n == 0L) {
            return 0L;
        }
        long remaining = n;
        while (remaining > 0L) {
            if (remaining <= (long)this.outBuffer.remaining()) {
                int pos = this.outBuffer.position() + (int)remaining;
                this.outBuffer.position(pos);
                remaining = 0L;
                break;
            }
            remaining -= (long)this.outBuffer.remaining();
            this.outBuffer.clear();
            int nd = 0;
            while (nd == 0) {
                nd = this.decryptMore();
            }
            if (nd < 0) break;
        }
        return n - remaining;
    }
}

