/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.rotation;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisReferenceFrame;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisSequence;

public final class AxisAngleSequence {
    private final AxisReferenceFrame referenceFrame;
    private final AxisSequence axisSequence;
    private final double angle1;
    private final double angle2;
    private final double angle3;

    public AxisAngleSequence(AxisReferenceFrame referenceFrame, AxisSequence axisSequence, double angle1, double angle2, double angle3) {
        this.referenceFrame = referenceFrame;
        this.axisSequence = axisSequence;
        this.angle1 = angle1;
        this.angle2 = angle2;
        this.angle3 = angle3;
    }

    public AxisReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public AxisSequence getAxisSequence() {
        return this.axisSequence;
    }

    public double getAngle1() {
        return this.angle1;
    }

    public double getAngle2() {
        return this.angle2;
    }

    public double getAngle3() {
        return this.angle3;
    }

    public double[] getAngles() {
        return new double[]{this.angle1, this.angle2, this.angle3};
    }

    public int hashCode() {
        return 107 * (199 * Objects.hash(new Object[]{this.referenceFrame, this.axisSequence})) + 7 * Double.hashCode(this.angle1) + 11 * Double.hashCode(this.angle2) + 19 * Double.hashCode(this.angle3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AxisAngleSequence)) {
            return false;
        }
        AxisAngleSequence other = (AxisAngleSequence)obj;
        return this.referenceFrame == other.referenceFrame && this.axisSequence == other.axisSequence && Double.compare(this.angle1, other.angle1) == 0 && Double.compare(this.angle2, other.angle2) == 0 && Double.compare(this.angle3, other.angle3) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[referenceFrame=").append((Object)this.referenceFrame).append(", axisSequence=").append((Object)this.axisSequence).append(", angles=").append(Arrays.toString(this.getAngles())).append(']');
        return sb.toString();
    }

    public static AxisAngleSequence createRelative(AxisSequence axisSequence, double angle1, double angle2, double angle3) {
        return new AxisAngleSequence(AxisReferenceFrame.RELATIVE, axisSequence, angle1, angle2, angle3);
    }

    public static AxisAngleSequence createAbsolute(AxisSequence axisSequence, double angle1, double angle2, double angle3) {
        return new AxisAngleSequence(AxisReferenceFrame.ABSOLUTE, axisSequence, angle1, angle2, angle3);
    }
}

