/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.stl.BinaryStlFacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlConstants;
import org.apache.commons.geometry.io.euclidean.threed.stl.TextStlFacetDefinitionReader;

public final class StlFacetDefinitionReaders {
    private StlFacetDefinitionReaders() {
    }

    public static FacetDefinitionReader create(InputStream in, Charset charset) {
        Charset inputCharset = charset != null ? charset : StlConstants.DEFAULT_CHARSET;
        byte[] testBytes = "solid".getBytes(inputCharset);
        byte[] actualBytes = new byte[testBytes.length];
        int read = GeometryIOUtils.applyAsIntUnchecked(in::read, (Object)actualBytes);
        if (read < actualBytes.length) {
            throw GeometryIOUtils.parseError((String)MessageFormat.format("Cannot determine STL format: attempted to read {0} bytes but found only {1} available", actualBytes.length, read));
        }
        PushbackInputStream pushbackInput = new PushbackInputStream(in, actualBytes.length);
        GeometryIOUtils.acceptUnchecked(pushbackInput::unread, (Object)actualBytes);
        if (Arrays.equals(testBytes, actualBytes)) {
            return new TextStlFacetDefinitionReader(new BufferedReader(new InputStreamReader((InputStream)pushbackInput, inputCharset)));
        }
        return new BinaryStlFacetDefinitionReader(pushbackInput);
    }
}

