/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.junit.Assert;
import org.junit.Test;

public class CertifiedDataTest {
    protected double mean = Double.NaN;
    protected double std = Double.NaN;

    @Test
    public void testSummaryStatistics() throws Exception {
        SummaryStatistics u = new SummaryStatistics();
        this.loadStats("data/PiDigits.txt", u);
        Assert.assertEquals((String)"PiDigits: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-13);
        Assert.assertEquals((String)"PiDigits: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-13);
        this.loadStats("data/Mavro.txt", u);
        Assert.assertEquals((String)"Mavro: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"Mavro: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/Michelso.txt", u);
        Assert.assertEquals((String)"Michelso: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-13);
        Assert.assertEquals((String)"Michelso: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-13);
        this.loadStats("data/NumAcc1.txt", u);
        Assert.assertEquals((String)"NumAcc1: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"NumAcc1: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/NumAcc2.txt", u);
        Assert.assertEquals((String)"NumAcc2: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"NumAcc2: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
    }

    @Test
    public void testDescriptiveStatistics() throws Exception {
        DescriptiveStatistics u = new DescriptiveStatistics();
        this.loadStats("data/PiDigits.txt", u);
        Assert.assertEquals((String)"PiDigits: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"PiDigits: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/Mavro.txt", u);
        Assert.assertEquals((String)"Mavro: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"Mavro: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/Michelso.txt", u);
        Assert.assertEquals((String)"Michelso: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"Michelso: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/NumAcc1.txt", u);
        Assert.assertEquals((String)"NumAcc1: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"NumAcc1: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
        this.loadStats("data/NumAcc2.txt", u);
        Assert.assertEquals((String)"NumAcc2: std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"NumAcc2: mean", (double)this.mean, (double)u.getMean(), (double)1.0E-14);
    }

    private void loadStats(String resource, Object u) throws Exception {
        DescriptiveStatistics d = null;
        SummaryStatistics s = null;
        if (u instanceof DescriptiveStatistics) {
            d = (DescriptiveStatistics)u;
        } else {
            s = (SummaryStatistics)u;
        }
        u.getClass().getDeclaredMethod("clear", new Class[0]).invoke(u, new Object[0]);
        this.mean = Double.NaN;
        this.std = Double.NaN;
        InputStream resourceAsStream = CertifiedDataTest.class.getResourceAsStream(resource);
        Assert.assertNotNull((String)("Could not find resource " + resource), (Object)resourceAsStream);
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream));
        String line = null;
        for (int j = 0; j < 60; ++j) {
            line = in.readLine();
            if (j == 40) {
                this.mean = Double.parseDouble(line.substring(line.lastIndexOf(":") + 1).trim());
            }
            if (j != 41) continue;
            this.std = Double.parseDouble(line.substring(line.lastIndexOf(":") + 1).trim());
        }
        line = in.readLine();
        while (line != null) {
            if (d != null) {
                d.addValue(Double.parseDouble(line.trim()));
            } else {
                s.addValue(Double.parseDouble(line.trim()));
            }
            line = in.readLine();
        }
        resourceAsStream.close();
        in.close();
    }
}

