/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.Incrementor;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class IncrementorTest {
    @Test
    public void testConstructor1() {
        Incrementor i = new Incrementor();
        Assert.assertEquals((long)0L, (long)i.getMaximalCount());
        Assert.assertEquals((long)0L, (long)i.getCount());
    }

    @Test
    public void testConstructor2() {
        Incrementor i = new Incrementor(10);
        Assert.assertEquals((long)10L, (long)i.getMaximalCount());
        Assert.assertEquals((long)0L, (long)i.getCount());
    }

    @Test
    public void testCanIncrement1() {
        Incrementor i = new Incrementor(3);
        Assert.assertTrue((boolean)i.canIncrement());
        i.incrementCount();
        Assert.assertTrue((boolean)i.canIncrement());
        i.incrementCount();
        Assert.assertTrue((boolean)i.canIncrement());
        i.incrementCount();
        Assert.assertFalse((boolean)i.canIncrement());
    }

    @Test
    public void testCanIncrement2() {
        Incrementor i = new Incrementor(3);
        while (i.canIncrement()) {
            i.incrementCount();
        }
        try {
            i.incrementCount();
            Assert.fail((String)"MaxCountExceededException expected");
        }
        catch (MaxCountExceededException maxCountExceededException) {
            // empty catch block
        }
    }

    @Test
    public void testAccessor() {
        Incrementor i = new Incrementor();
        i.setMaximalCount(10);
        Assert.assertEquals((long)10L, (long)i.getMaximalCount());
        Assert.assertEquals((long)0L, (long)i.getCount());
    }

    @Test
    public void testBelowMaxCount() {
        Incrementor i = new Incrementor();
        i.setMaximalCount(3);
        i.incrementCount();
        i.incrementCount();
        i.incrementCount();
        Assert.assertEquals((long)3L, (long)i.getCount());
    }

    @Test(expected=MaxCountExceededException.class)
    public void testAboveMaxCount() {
        Incrementor i = new Incrementor();
        i.setMaximalCount(3);
        i.incrementCount();
        i.incrementCount();
        i.incrementCount();
        i.incrementCount();
    }

    @Test(expected=TooManyEvaluationsException.class)
    public void testAlternateException() {
        Incrementor.MaxCountExceededCallback cb = new Incrementor.MaxCountExceededCallback(){

            public void trigger(int max) {
                throw new TooManyEvaluationsException((Number)max);
            }
        };
        Incrementor i = new Incrementor(0, cb);
        i.incrementCount();
    }

    @Test
    public void testReset() {
        Incrementor i = new Incrementor();
        i.setMaximalCount(3);
        i.incrementCount();
        i.incrementCount();
        i.incrementCount();
        Assert.assertEquals((long)3L, (long)i.getCount());
        i.resetCount();
        Assert.assertEquals((long)0L, (long)i.getCount());
    }

    @Test
    public void testBulkIncrement() {
        Incrementor i = new Incrementor();
        i.setMaximalCount(3);
        i.incrementCount(2);
        Assert.assertEquals((long)2L, (long)i.getCount());
        i.incrementCount(1);
        Assert.assertEquals((long)3L, (long)i.getCount());
    }
}

