// Licensed under the Apache License, Version 2.0 (the "License"); you may not
// use this file except in compliance with the License. You may obtain a copy of
// the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations under
// the License.

import PropTypes from 'prop-types';
import React from "react";

export default function IndexFields ({fields, isTextIndex}) {
  if (!fields) {
    return null;
  }
  if (fields.length === 0) {
    return <div className='col-12'>{isTextIndex ? 'All fields' : 'No fields'}</div>;
  }

  const fieldsList = fields.map((field) => {
    const fieldName = Object.getOwnPropertyNames(field)[0];
    const sortOrder = field[fieldName];
    const icon = sortOrder === 'asc' ?
      <i className="icon fonticon-up-1"></i> :
      <i className="icon fonticon-down-1"></i>;
    return <div key={fieldName} className='col-12'>{fieldName}{icon}</div>;
    // return {fieldEntry};
  });

  return <div className='row'>{fieldsList}</div>;
}

IndexFields.propTypes = {
  fields: PropTypes.arrayOf(PropTypes.object).isRequired,
  isTextIndex: PropTypes.bool,
};
