/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.DataToDoublesSketchUDAF;
import org.apache.datasketches.hive.quantiles.DoublesUnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToDoublesSketchUDAFTest {
    static final ObjectInspector doubleInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(intInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongTypeArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void partial1ModeDefaultK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0)});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeGivenK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new IntWritable(256)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new IntWritable(256)});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{doubleInspector}, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{binaryInspector});
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().build();
            sketch1.update(1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().build();
            sketch2.update(2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void finalMode() throws Exception {
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{doubleInspector}, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{binaryInspector});
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(256).build();
            sketch1.update(1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray()));
            UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(256).build();
            sketch2.update(2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray()));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void completeModeDefaultK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0)});
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    @Test
    public void completeModeGivenK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            DoublesUnionState state = (DoublesUnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new IntWritable(256)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new IntWritable(256)});
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            DoublesSketch resultSketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((double)resultSketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)resultSketch.getMaxItem(), (double)2.0);
        }
    }

    static void checkResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

