/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.DataToSketchUDAFTest;
import org.apache.datasketches.hive.theta.IntersectSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntersectSketchUDAFTest {
    static final ObjectInspector longInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG);
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("seed", "sketch"), Arrays.asList(longInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, longInspector, longInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg1() throws Exception {
        AbstractPrimitiveWritableObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void partia1lDefaultSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            IntersectSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState state = (IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            sketch1.update(2L);
            sketch1.update(3L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray())});
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            sketch2.update(3L);
            sketch2.update(4L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray())});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((long)((LongWritable)r.get(0)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))));
            Assert.assertEquals((int)resultSketch.getRetainedEntries(true), (int)2);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeExplicitSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, longInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            IntersectSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            long seed = 1L;
            IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState state = (IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().setSeed(1L).build();
            sketch1.update(1L);
            sketch1.update(2L);
            sketch1.update(3L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray()), new LongWritable(1L)});
            UpdateSketch sketch2 = UpdateSketch.builder().setSeed(1L).build();
            sketch2.update(2L);
            sketch2.update(3L);
            sketch2.update(4L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray()), new LongWritable(1L)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((long)((LongWritable)r.get(0)).get(), (long)1L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))), (long)1L);
            Assert.assertEquals((int)resultSketch.getRetainedEntries(true), (int)2);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            IntersectSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState state = (IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            sketch1.update(2L);
            sketch1.update(3L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            sketch2.update(3L);
            sketch2.update(4L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((long)((LongWritable)r.get(0)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState state = (IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            sketch1.update(2L);
            sketch1.update(3L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            sketch2.update(3L);
            sketch2.update(4L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes));
            Assert.assertEquals((int)resultSketch.getRetainedEntries(true), (int)2);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeDefaultSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new IntersectSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState state = (IntersectSketchUDAF.IntersectSketchUDAFEvaluator.IntersectionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            sketch1.update(2L);
            sketch1.update(3L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            sketch2.update(3L);
            sketch2.update(4L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    private static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)2);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

