/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.List;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToEstimatesUDF;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToEstimatesUDFTest {
    @Test
    public void nullSketch() {
        List result = new ArrayOfDoublesSketchToEstimatesUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchToEstimatesUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.0);
    }

    @Test
    public void normalCase() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        List result = new ArrayOfDoublesSketchToEstimatesUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)2.0);
    }
}

